import pytest
from peewee import DoesNotExist, IntegrityError
from median.models import LdapServer, LdapServerProfil
from median.base import MedianLibException
from datetime import datetime


class TestModelLdap:

    def test_ldap_server_creation(self):
        server = LdapServer()
        server.username = "admin"
        server.password = "admin"
        server.dn = """CN=OK,OU=Test,DC=deenova,DC=local"""
        server.save()
        assert server.pk > 0
        server.delete_instance()

    def test_ldap_server_profil_creation(self):
        server = LdapServer()
        server.username = "admin"
        server.password = "admin"
        server.dn = """CN=OK,OU=Test,DC=deenova,DC=local"""
        server.save()
        assert server.pk > 0

        profil = LdapServerProfil()
        profil.profil = "INFIRMIER"
        profil.annuaire_id = server
        profil.dn = "CN=Test,OU=Ok,DC=medianweb,DC=local"
        profil.save()

        assert profil.pk > 0

        server.delete_instance()
