import pytest
from peewee import DoesNotExist
from median.models import Stock, CodeBlocage, Magasin
from median.models import Adresse
from median.constant import ExternalMachineType
from datetime import datetime
import time


class TestMagasinExternal:

    def test_unknown_magasin(self):
        with pytest.raises(ValueError) as e:
            mag = Magasin()
            mag.mag = "S01"
            mag.type_mag = "STATIC_1"
            mag.eco_type = "Z"
            mag.save()
        assert 'eco type' in str(e)

    def test_external_magasin_etagere(self):
        mag = Magasin()
        mag.mag = "S00"
        mag.type_mag = "STATIC_0"
        mag.eco_type = "E"
        mag.type_machine = ExternalMachineType.Etagere.value
        mag.save()
        assert mag.pk > 0
        mag.delete_instance()

    def test_external_magasin_chariot(self):
        mag = Magasin()
        mag.mag = "S10"
        mag.type_mag = "STATIC_10"
        mag.eco_type = "E"
        mag.type_machine = ExternalMachineType.Chariot.value
        mag.save()
        assert mag.pk > 0
        mag.delete_instance()
