from peewee import AutoField, IntegerField, CharField
from peewee import SQL

from ..base import BaseModel


class Peigne(BaseModel):
    pk = AutoField(
        column_name='x_pk', primary_key=True)
    type_peigne = IntegerField(
        column_name='x_type_peigne', constraints=[SQL("DEFAULT 0")], default=0)
    nb_pilulier = IntegerField(
        column_name='x_nb_pilulier', constraints=[SQL("DEFAULT 1")], default=1)
    taille = IntegerField(
        column_name='x_taille', constraints=[SQL("DEFAULT 1")], default=1)
    alveole = IntegerField(
        column_name='x_alveole', constraints=[SQL("DEFAULT 4")], default=4)
    libelle = CharField(
        column_name='x_libelle', max_length=50, null=True, constraints=[SQL("DEFAULT ''")])
    mode = CharField(
        column_name='x_mode_type', max_length=1, null=True, constraints=[SQL("DEFAULT ''")])

    class Meta:
        table_name = 'f_peigne'
        indexes = (
            (('x_type_peigne',), True),
        )
