# flake8: noqa
import pytest
from median.base import MedianLibException
from median.models import Historique
from median.constant import HistoryType, PatientGlobal
import time
from datetime import datetime


class TestModelHistorique:

    def test_unknown_movement(self):
        """Test creation of an unknown movement"""
        with pytest.raises(MedianLibException):
            h = Historique()
            h.chrono = datetime.now
            h.reference = "DEVERMINAGE"
            h.adresse = "ST1. xxx. XXX. yyy"
            h.type_mouvement = 'UNK'
            h.quantite_mouvement = 5
            h.quantite_demande = 5
            h.quantite_totale = 123
            h.liste = "Liste 1234"
            h.service = "ECODEX"
            h.lot = "1234"
            h.utilisateur = "ADMIN"
            h.magasin = "ST1"
            h.save()

    def test_create_entry_movement(self):
        """Test création d'une entrée"""
        h = Historique()
        h.chrono = datetime.now
        h.reference = "DEVERMINAGE"
        h.adresse = "ST1. xxx. XXX. yyy"
        h.type_mouvement = HistoryType.Entree.value
        h.quantite_mouvement = 5
        h.quantite_demande = 5
        h.quantite_totale = 123
        h.liste = "Liste 1234"
        h.service = "ECODEX"
        h.lot = "1234"
        h.utilisateur = "ADMIN"
        h.magasin = "ST1"
        h.save()
        assert h.pk > 0
        h.delete_instance()

    def test_create_exit_movement_no_ipp(self):
        """Test création d'une entrée"""
        h = Historique()
        h.chrono = datetime.now
        h.reference = "DEVERMINAGE"
        h.adresse = "ST1. xxx. XXX. yyy"
        h.type_mouvement = HistoryType.Sortie.value
        h.quantite_mouvement = 5
        h.quantite_demande = 5
        h.quantite_totale = 123
        h.liste = "Liste 1234"
        h.service = "ECODEX"
        h.lot = "1234"
        h.utilisateur = "ADMIN"
        h.magasin = "ST1"
        h.save()
        assert h.pk > 0
        assert h.ipp == PatientGlobal.Ipp.value
        assert h.sejour == PatientGlobal.Sejour.value
        h.delete_instance()

    def test_create_exit_movement_with_ipp(self):
        """Test création d'une entrée"""
        h = Historique()
        h.chrono = datetime.now
        h.reference = "DEVERMINAGE"
        h.adresse = "ST1. xxx. XXX. yyy"
        h.type_mouvement = HistoryType.Sortie.value
        h.quantite_mouvement = 5
        h.quantite_demande = 5
        h.quantite_totale = 123
        h.liste = "Liste 1234"
        h.service = "ECODEX"
        h.lot = "1234"
        h.utilisateur = "ADMIN"
        h.magasin = "ST1"
        h.ipp = 'PYTEST'
        h.sejour = 'PYTEST'
        h.save()
        assert h.pk > 0
        assert h.ipp != PatientGlobal.Ipp.value
        assert h.sejour != PatientGlobal.Sejour.value
        h.delete_instance()

    def test_create_exit_movement_date_value(self):
        """Test création d'une entrée"""
        h = Historique()
        h.reference = "DEVERMINAGE"
        h.adresse = "ST1. xxx. XXX. yyy"
        h.type_mouvement = HistoryType.Sortie.value
        h.quantite_mouvement = 5
        h.quantite_demande = 5
        h.quantite_totale = 123
        h.liste = "Liste 1234"
        h.service = "ECODEX"
        h.lot = "1234"
        h.utilisateur = "ADMIN"
        h.magasin = "ST1"
        h.ipp = 'PYTEST'
        h.sejour = 'PYTEST'
        h.save()
        assert h.pk > 0
        assert h.chrono > datetime(2000, 1, 1, 0, 0, 0)
        h.delete_instance()
