# flake8: noqa
import pytest
from peewee import DoesNotExist
from median.models import LogAstus, LogInfo, LogEchangeRiedl, LogDefaut, MagLogDefault, LogScan
from datetime import datetime


class TestLogAstus:
    def test_log_astus_ok(self):
        log = LogAstus()

    def test_log_info_ok(self):
        log = LogInfo()

    def test_log_info_save(self):
        log = LogInfo()
        log.poste = "MIRTH"
        log.section = "PATIENT"
        log.log = """Message
        multiligne
        encore une
        """
        log.save()


class TestLogRiedl:
    def test_log_create(self):
        log = LogEchangeRiedl()
        log.chrono = datetime.now
        log.poste = "RIEDL_00"
        log.type = "INP"
        log.reference = "ECO0000"
        log.qte = 10
        log.lot = "ABCD"
        log.tperemp = datetime.now
        log.gtin = "1234567891234"
        log.save()
        assert log.pk > 0
        log.delete_instance()


class TestLogDefaut:

    def test_log_defaut_insert(self):
        log = LogDefaut()
        log.chrono = datetime.now
        log.poste = "ACCED_STX"
        log.num_defaut = "0000"
        log.valeur = "0"
        log.message = "OK"
        log.save()
        assert log.pk > 0
        log.delete_instance()


class TestMagLogDefault:
    def test_mag_log_defaut(self):
        log = MagLogDefault()
        log.chrono = datetime.now()
        log.poste = "ACCED_STX"
        log.num_defaut = "0000"
        log.message = "OK"
        log.save()
        assert log.pk > 0
        log.delete_instance()


class TestLogScan:
    def test_log_scan(self):
        log: LogScan = LogScan()
        log.chrono = datetime.now()
        log.value = "1234567890123"
        log.scan_date = datetime.now()
        log.scan_gtin = "03400936854703"
        log.scan_serial = "123456X01201234"
        log.save()
        assert log.pk > 0
        log.delete_instance()



