import pytest
from peewee import DoesNotExist, IntegrityError
from median.models import Printer, PrinterCommand, PrinterCommandLabel, PrinterLabel, PrinterMag, PrinterType, PrinterLog, Magasin, User
from median.base import MedianLibException
from datetime import datetime


@pytest.fixture()
def rectest():
    print("Running method level setUp")
    Magasin.delete().where(Magasin.mag=="L99").execute()
    PrinterType.delete().where(PrinterType.lang == "ZPL").execute()
    PrinterLabel.delete().execute()
    Printer.delete().execute()
    User.delete().where(User.username=="221122").execute()
    rec_data = {}

    mag1 = Magasin(
        mag="L99",
    )
    mag1.type_mag = "RIEDL99"
    mag1.libelle = "Riedl 99"
    mag1.eco_type = "L"
    mag1.save()

    usr = User()
    usr.username = "221122"
    usr.password = "xxxx"
    usr.passwordWeb = "zzzz"
    usr.badge = "10101"
    usr.profil = "ECO-DEX"
    usr.date_creation = datetime.now()
    usr.lang = "fr"
    usr.save()

    rec_data['mag1'] = mag1
    rec_data['usr1'] = usr
    yield rec_data

    print("Running method level tearDown")
    mag1.delete_instance()
    usr.delete_instance()


class TestModelPrinter:

    def test_printer_creation(self, rectest):
        ptype = PrinterType()
        ptype.name = "GX430"
        ptype.lang = "ZPL"
        ptype.save()

        plabel = PrinterLabel()
        plabel.name = "78x44"
        plabel.width = 78
        plabel.height = 44
        plabel.save()

        printer = Printer()
        printer.name = "RIEDL 1 GX 430"
        printer.type_id = ptype
        printer.address = "zpl+tcp://127.0.0.1:9100"
        printer.current_label_id = plabel
        printer.option_cut = 1
        printer.save()

        assert printer.type_id.name == ptype.name
        assert printer.current_label_id.name == plabel.name

        printer.delete_instance()
        plabel.delete_instance()
        ptype.delete_instance()

    def test_printer_mag(self, rectest):
        ptype = PrinterType()
        ptype.name = "GX430"
        ptype.lang = "ZPL"
        ptype.save()

        plabel = PrinterLabel()
        plabel.name = "78x44"
        plabel.width = 78
        plabel.height = 44
        plabel.save()

        printer = Printer()
        printer.name = "RIEDL 1 GX 430"
        printer.type_id = ptype
        printer.address = "zpl+tcp://127.0.0.1:9100"
        printer.current_label_id = plabel
        printer.option_cut = 1
        printer.save()

        p_mag = PrinterMag()
        p_mag.printer_id = printer
        p_mag.mag_id = rectest['mag1']
        p_mag.primary = 1
        p_mag.save()

        assert printer.type_id.name == ptype.name
        assert printer.current_label_id.name == plabel.name
        assert printer.printer[0].primary == 1
        assert printer.printer[0].mag_id == rectest['mag1']

        p_mag.delete_instance()
        printer.delete_instance()
        plabel.delete_instance()
        ptype.delete_instance()

    def test_printer_log(self, rectest):
        ptype = PrinterType()
        ptype.name = "GX430"
        ptype.lang = "ZPL"
        ptype.save()

        plabel = PrinterLabel()
        plabel.name = "78x44"
        plabel.width = 78
        plabel.height = 44
        plabel.save()

        printer = Printer()
        printer.name = "RIEDL 1 GX 430"
        printer.type_id = ptype
        printer.address = "zpl+tcp://127.0.0.1:9100"
        printer.current_label_id = plabel
        printer.option_cut = 1
        printer.save()

        p_mag = PrinterMag()
        p_mag.printer_id = printer
        p_mag.mag_id = rectest['mag1']
        p_mag.primary = 1
        p_mag.save()

        p_log = PrinterLog()
        p_log.printer_id = printer
        p_log.user_id = rectest['usr1']
        p_log.content = """ZPL Power"""
        p_log.label_id = plabel
        p_log.save()

        assert printer.type_id.name == ptype.name
        assert printer.current_label_id.name == plabel.name
        assert printer.printer[0].primary == 1
        assert printer.printer[0].mag_id == rectest['mag1']
        assert printer.printer_log[0].user_id == rectest['usr1']
        assert printer.printer_log[0].label_id == plabel
        assert rectest['usr1'].user_log[0].content == p_log.content
        assert plabel.label_log[0].printer_id == printer

        p_log.delete_instance()
        p_mag.delete_instance()
        printer.delete_instance()
        plabel.delete_instance()
        ptype.delete_instance()

    def test_printer_command(self, rectest):
        ptype = PrinterType()
        ptype.name = "GX430"
        ptype.lang = "ZPL"
        ptype.save()

        plabel = PrinterLabel()
        plabel.name = "78x44"
        plabel.width = 78
        plabel.height = 44
        plabel.save()

        printer = Printer()
        printer.name = "RIEDL 1 GX 430"
        printer.type_id = ptype
        printer.address = "zpl+tcp://127.0.0.1:9100"
        printer.current_label_id = plabel
        printer.option_cut = 1
        printer.save()

        command = PrinterCommand()
        command.name = "Drugs labels"
        command.code = "DRUG_LABEL"
        command.save()

        printer_command = PrinterCommandLabel()
        printer_command.label_id = plabel
        printer_command.command_id = command
        printer_command.print_code = "^XA%(name)s^XZ"
        printer_command.print_dict = "{'name': 'paracetamol'}"
        printer_command.save()

        assert printer.type_id.name == ptype.name
        assert printer.current_label_id.name == plabel.name
        assert command.command[0].print_code == printer_command.print_code
        assert command.command[0].print_dict == printer_command.print_dict

        printer_command.delete_instance()
        command.delete_instance()
        printer.delete_instance()
        plabel.delete_instance()
        ptype.delete_instance()
