import pytest
from peewee import DoesNotExist, IntegrityError
from median.models import Peigne
import time
from datetime import datetime


class TestModelPeigne:
    def test_unknown_peigne(self):
        """Test d'un peigne inexistant"""
        with pytest.raises(DoesNotExist):
            Peigne.get(type_peigne=1000)

    def test_create_peigne(self):
        """Create a peigne"""
        pos = Peigne()
        pos.nb_pilulier = 7
        pos.taille = 1
        pos.alveole = 4
        pos.save()
        assert pos.pk > 0
        pos.delete_instance()
