# flake8: noqa
import pytest
from peewee import DoesNotExist
from median.models import Patient
import time
from datetime import datetime


class TestModelPatient:
    def test_unknown_ipp_patient(self):
        """Test d'un patient inexistant"""
        with pytest.raises(DoesNotExist):
            Patient.get(ipp="INCONNU")

    def test_unknown_nom_patient(self):
        """Test d'un patient inexistant"""
        with pytest.raises(DoesNotExist):
            Patient.get(nom="INCONNU")

    def test_creation_patient(self):
        """Creation d'un patient"""
        pat = Patient(nom="Test", prenom="Patrick")
        pat.ipp = "ABCD1234"
        pat.sexe = "M"
        pat.date_maj = datetime.now()
        pat.save()
        assert pat.pk > 0
        assert pat.date_maj.strftime("%Y-%m-%d") == time.strftime("%Y-%m-%d")
        pat.delete_instance()
