from median.base import InnodbModel
from peewee import DateTimeField, SQL, CharField, IntegerField, BooleanField, ForeignKeyField, \
    TextField, ManyToManyField, AutoField


class NonConformityErrorType(InnodbModel):
    pk = AutoField(column_name='pk', primary_key=True)
    label = TextField(column_name='label')

    class Meta:
        table_name = 'f_nc_error_type'


class NonConformity(InnodbModel):
    pk = AutoField(column_name='pk', primary_key=True)
    create_date = DateTimeField(column_name='create_date')
    closing_date = DateTimeField(column_name='closing_date', null=True)
    close_by = IntegerField(column_name='close_by', null=True, default=None)
    username = CharField(column_name='username', max_length=20)
    user_pk = IntegerField(column_name='user_pk', null=True, default=None)
    control_date = DateTimeField(column_name='control_date', null=True)
    dispensation_start = DateTimeField(
        column_name='dispensation_start', null=True)
    dispensation_end = DateTimeField(
        column_name='dispensation_end', null=True)
    control_date = DateTimeField(
        column_name='control_date', null=True)
    equipment_pk = IntegerField(column_name='equipment_pk', null=True, default=None)
    double_nominative_control = BooleanField(
        column_name="double_nominative_control", constraints=[SQL("DEFAULT 0")], default=False
    )
    double_presence_control = BooleanField(
        column_name="double_presence_control", constraints=[SQL("DEFAULT 0")], default=False
    )
    controled_quantity = IntegerField(column_name='controled_quantity', default=0)
    comment = TextField(column_name='comment', null=True)

    class Meta:
        table_name = 'f_non_conformity'


class NonConformityReport(InnodbModel):
    pk = AutoField(column_name='pk', primary_key=True)
    create_date = DateTimeField(column_name='create_date', null=True)
    create_by = IntegerField(column_name='create_by', null=True, default=None)
    validate_date = DateTimeField(column_name='validate_date', null=True)
    validate_by = IntegerField(column_name='validate_by', null=True, default=None)
    control = ForeignKeyField(NonConformity, backref='reports', lazy_load=False)
    room = CharField(
        column_name='room', max_length=10, constraints=[SQL("DEFAULT ''")])
    bagger = CharField(
        column_name='bagger', max_length=30, constraints=[SQL("DEFAULT ''")])
    serial = CharField(
        column_name='serial', max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    has_action = BooleanField(
        column_name="has_action", constraints=[SQL("DEFAULT 0")], default=False
    )
    unitdose_keeped = BooleanField(column_name="unitdose_keeped", constraints=[SQL("DEFAULT 0")], default=False)
    reference = TextField(column_name='reference')
    comment = TextField(column_name='comment', null=True)
    errors = ManyToManyField(NonConformityErrorType, backref='reports')

    class Meta:
        table_name = 'f_nc_report'


class NonConformityTest(InnodbModel):
    pk = AutoField(column_name='pk', primary_key=True)
    create_date = DateTimeField(
        column_name='create_date', null=True)
    validate_date = DateTimeField(
        column_name='validate_date', null=True)
    create_by = IntegerField(column_name='create_by', null=True, default=None)
    validate_by = IntegerField(column_name='validate_by', null=True, default=None)
    control = ForeignKeyField(NonConformity, backref='tests', lazy_load=False)
    pillbox_num = IntegerField(
        column_name='pillbox_num', null=True, default=None)

    class Meta:
        table_name = 'f_non_conformity_test'


class NonConformityTestLine(InnodbModel):
    pk = AutoField(column_name='pk', primary_key=True)
    test = ForeignKeyField(NonConformityTest, backref='tests', lazy_load=False)
    create_date = DateTimeField(
        column_name='create_date', null=True)
    validate_date = DateTimeField(
        column_name='validate_date', null=True)
    create_by = IntegerField(column_name='create_by', null=True, default=None)
    validate_by = IntegerField(column_name='validate_by', null=True, default=None)
    item_pk = IntegerField(column_name='item_pk', null=True, default=None)
    controlled_quantity = IntegerField(
        column_name='controlled_quantity', constraints=[SQL("DEFAULT 0")], default=0)
    conform = BooleanField(
        column_name="conform", constraints=[SQL("DEFAULT 0")], default=False
    )
    nonconform = BooleanField(
        column_name="nonconform", constraints=[SQL("DEFAULT 0")], default=False
    )

    class Meta:
        table_name = 'f_non_conformity_test_line'
        indexes = (
            (('test_id', 'item_pk'), False),
            (('test_id', 'item_pk', 'controlled_quantity'), False),
        )


class NonConformityError(InnodbModel):
    pk = AutoField(column_name='pk', primary_key=True)
    create_date = DateTimeField(
        column_name='create_date', null=True)
    create_by = IntegerField(column_name='create_by', null=True, default=None)
    test_line = ForeignKeyField(NonConformityTestLine, backref='errors', lazy_load=False)
    serial = CharField(
        column_name='serial', max_length=20, null=True, default='')
    dose_keeped = BooleanField(
        column_name="dose_keeped", default=False
    )
    corrective_action = BooleanField(
        column_name="corrective_action",  default=False
    )
    description = TextField(column_name='description')
    bagger = IntegerField(column_name='bagger', null=True, default=None)
    error_type = ForeignKeyField(NonConformityErrorType, backref='defects', lazy_load=False)

    class Meta:
        table_name = 'f_non_conformity_error'
