from peewee import IntegerField, CharField
from ..base import BaseModel
from peewee import SQL


class Web_Menu(BaseModel):

    id = IntegerField(
        column_name='id', primary_key=True)
    name = CharField(
        column_name='name')
    code = CharField(
        column_name='code')
    icon = CharField(
        column_name='icon')
    parent_id = CharField(
        column_name="parent_id", null=True)
    seq_order = IntegerField(
        column_name="seq_order", null=True)
    url = CharField(
        column_name='url')
    anchor = CharField(
        column_name='anchor')

    class Meta:
        table_name = 'web_menu'


class Web_Menu_i18n(BaseModel):

    id = IntegerField(
        column_name='id', primary_key=True)
    menu_id = CharField(
        column_name="menu_id", null=True, constraints=[SQL("DEFAULT ''")])
    type_mag = CharField(
        column_name="lang_id", null=True, constraints=[SQL("DEFAULT ''")])
    tr_name = CharField(
        column_name='tr_name')

    class Meta:
        table_name = 'web_menu_i18n'
