from peewee import (
    AutoField,
    CharField,
    IntegerField,
    BooleanField,
    FloatField,
    DateTimeField,
    SmallIntegerField,
)
from peewee import SQL
from ..base import BaseModel, MedianLibException
from ..constant import HistoryType, PatientGlobal
import datetime


class Historique(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")], default=datetime.datetime.now)
    reference = CharField(
        column_name='x_ref', null=True, max_length=35, constraints=[SQL("DEFAULT ''")])
    adresse = CharField(
        column_name='x_adr', null=True, max_length=19, constraints=[SQL("DEFAULT ''")], default='')
    quantite_mouvement = FloatField(
        column_name='x_qte_mvt', null=True, constraints=[SQL("DEFAULT 0.000")], default=0.0)
    quantite_totale = FloatField(
        column_name='x_qte_tot', null=True, constraints=[SQL("DEFAULT 0.000")], default=0.0)
    info = CharField(
        column_name='x_info', max_length=100, constraints=[SQL("DEFAULT ''")], default='')
    liste = CharField(
        column_name='x_liste', null=True, max_length=60, constraints=[SQL("DEFAULT ''")], default='')
    service = CharField(
        column_name='x_dest', null=True, max_length=30, constraints=[SQL("DEFAULT ''")], default='')
    type_mouvement = CharField(
        column_name='x_type_mvt', null=True, max_length=3, constraints=[SQL("DEFAULT ''")], default='')
    lot = CharField(
        column_name='x_lot', null=True, max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    adresse_from = CharField(
        column_name='x_adr_from', null=True, max_length=19, constraints=[SQL("DEFAULT ''")], default='')
    utilisateur = CharField(
        column_name='x_user', null=True, max_length=60, constraints=[SQL("DEFAULT ''")], default='')
    commentaire = CharField(
        column_name='x_comment', null=True, max_length=50, constraints=[SQL("DEFAULT ''")], default='')
    admin = CharField(
        column_name='x_admin', null=True, max_length=10, constraints=[SQL("DEFAULT ''")], default='')
    kit = CharField(
        column_name='x_kit', null=True, max_length=35, constraints=[SQL("DEFAULT ''")], default='')
    # emprunt = CharField(
    #     column_name='x_emprunt', null=True, constraints=[SQL("DEFAULT ''")])
    # pmp = FloatField(
    #     column_name='x_pmp', null=True, constraints=[SQL("DEFAULT 0.000")])
    date_peremption = DateTimeField(
        column_name='x_tperemp', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    date_quarantaine = DateTimeField(
        column_name='x_tquarant', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    prix_unitaire = FloatField(
        column_name='x_prix_u', null=True, constraints=[SQL("DEFAULT 0.000")], default=0.0)
    sequence = CharField(
        column_name='x_sequence', null=True, max_length=25, constraints=[SQL("DEFAULT ''")], default='')
    interface = CharField(
        column_name='x_interface', max_length=15, constraints=[SQL("DEFAULT ''")], default='')
    magasin = CharField(
        column_name='x_num_mag', null=True, max_length=3, constraints=[SQL("DEFAULT ''")], default='')
    item = CharField(
        column_name='x_item', null=True, max_length=40, constraints=[SQL("DEFAULT ''")], default='')
    demandeur = CharField(
        column_name='x_demandeur', null=True, max_length=1, constraints=[SQL("DEFAULT ''")], default='')
    date_demande = CharField(
        column_name='x_date_dem', null=True, max_length=8, constraints=[SQL("DEFAULT ''")], default='')
    heure_demande = CharField(
        column_name='x_heure_dem', null=True, max_length=8, constraints=[SQL("DEFAULT ''")], default='')
    libelle_unite = CharField(
        column_name='x_lib_unite', null=True, max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    quantite_demande = FloatField(
        column_name='x_qte_dem', null=True, constraints=[SQL("DEFAULT 0.000")], default=0)
    numero_demande = FloatField(
        column_name='x_num_dem', null=True, constraints=[SQL("DEFAULT 0")], default=0)
    quantite_dispensation = FloatField(
        column_name='x_qte_disp', null=True, constraints=[SQL("DEFAULT 0.000")], default=0)
    contenant = CharField(
        column_name='x_contenant', null=True, max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    # compte_budget = CharField(
    #     column_name='x_cpt_budg', null=True, constraints=[SQL("DEFAULT ''")])
    fournisseur = CharField(
        column_name='x_four', null=True, max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    fusion = CharField(
        column_name='x_fusion', null=True, max_length=35, constraints=[SQL("DEFAULT ''")], default='')
    quantite_picking = FloatField(
        column_name='x_qte_pick', null=True, constraints=[SQL("DEFAULT 0.000")], default=0.0)
    # quantite_res = FloatField(
    #     column_name='x_qte_res', null=True, constraints=[SQL("DEFAULT 0.000")])
    # refour = CharField(
    #     column_name='x_refour', null=True, constraints=[SQL("DEFAULT ''")])
    # magh2 = BooleanField(
    #     column_name='x_magh2', constraints=[SQL("DEFAULT 0")])
    ipp = CharField(
        column_name='x_num_ipp', max_length=35, constraints=[SQL("DEFAULT ''")], default='')
    sejour = CharField(
        column_name='x_num_sej', max_length=35, constraints=[SQL("DEFAULT ''")], default='')
    date_service = DateTimeField(
        column_name='x_tservice', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    poste = CharField(
        column_name='x_poste', null=True, max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    type_liste_web = IntegerField(
        column_name='x_type_liste_web', constraints=[SQL("DEFAULT 0")], default=0)
    createur = CharField(
        column_name='x_createur', max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    dot = CharField(
        column_name='x_dot', max_length=35, constraints=[SQL("DEFAULT ''")], default='')
    quantite_totale_lot = FloatField(
        column_name='x_qte_tot_adr_lot_peremp', constraints=[SQL("DEFAULT 0.000")], default=0.0)
    # date_inventaire_termine = DateTimeField(
    #     column_name='x_t_inv_term', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    pk_liste = IntegerField(
        column_name='x_pk_liste', constraints=[SQL("DEFAULT 0")], default=0)
    serial = CharField(
        column_name='x_serial', max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    ucd = CharField(
        column_name='x_ucd', max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    date_prise = DateTimeField(
        column_name='xx_dtprise', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    id_pilulier = CharField(
        column_name='xx_id_pilulier', max_length=40, constraints=[SQL("DEFAULT ''")], default='')
    moment = CharField(
        column_name='xx_moment', max_length=35, constraints=[SQL("DEFAULT ''")], default='')
    heure = CharField(
        column_name='xx_heure', max_length=4, constraints=[SQL("DEFAULT ''")], default='')
    id_prescription = IntegerField(
        column_name='xx_id_presc', constraints=[SQL("DEFAULT 0")], default=0)
    readonly = BooleanField(
        column_name='x_readonly', constraints=[SQL("DEFAULT 0")], default=0)
    date_debut = DateTimeField(
        column_name='xx_ddeb', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    fraction = IntegerField(
        column_name='x_fraction', constraints=[SQL("DEFAULT 100")], default=100)
    quantite_prescrite = FloatField(
        column_name='x_qte_prescrite', constraints=[SQL("DEFAULT 0.000")], default=0.0)
    pk_item = IntegerField(
        column_name='x_pk_item', constraints=[SQL("DEFAULT 0")], default=0)
    item_wms = IntegerField(
        column_name='x_item_wms', constraints=[SQL("DEFAULT 0")], default=0)
    sous_secteur = CharField(
        column_name='xx_sous_secteur', max_length=100, constraints=[SQL("DEFAULT ''")], default='')
    id_plateau = CharField(
        column_name='xx_id_plateau', max_length=40, constraints=[SQL("DEFAULT ''")], default='')
    numero_pilulier = IntegerField(
        column_name='xx_no_pilulier', constraints=[SQL("DEFAULT 0")], default=0)
    id_peigne = IntegerField(
        column_name='xx_id_peigne', constraints=[SQL("DEFAULT 0")], default=0)

    def save(self, force_insert=False, only=None):
        """Enforce control on each information passed"""
        # Check if type movement exists on the list
        if self.type_mouvement not in [m.value for m in HistoryType]:
            raise MedianLibException("Type movement (%s) is not a HistoryType value" % self.type_mouvement)
        if self.type_mouvement == HistoryType.Sortie.value:
            if not self.ipp:
                self.ipp = PatientGlobal.Ipp.value
            if not self.sejour:
                self.sejour = PatientGlobal.Sejour.value
        return super().save(force_insert, only)

    class Meta:
        table_name = 'f_histo'
        indexes = (
            (('x_chrono',), False),
            (('x_dest',), False),
            (('x_item',), False),
            (('x_item_wms',), False),
            (('x_liste',), False),
            (('x_pk_liste',), False),
            (('x_ref',), False),
            (('x_serial',), False),
            (('x_type_mvt',), False),
            (('x_ucd',), False),
            (('xx_id_pilulier',), False),
            (('xx_id_plateau',), False),
            (('xx_id_presc',), False),
            (('x_pk', 'x_ref', 'x_adr', 'x_chrono', 'x_type_mvt', 'x_qte_dem', 'x_fraction',), False),
            (('x_adr', 'x_chrono', 'x_type_mvt'), False),
            (('x_ref', 'x_adr', 'x_chrono', 'x_type_mvt', 'x_fraction',), False),
        )


class HistoriqueBlocage(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono',
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")], default=datetime.datetime.now)
    adresse = CharField(
        column_name='x_adr', max_length=19, constraints=[SQL("DEFAULT ''")], default='')
    bloque = IntegerField(
        column_name='x_bloque', constraints=[SQL("DEFAULT 0")], default=0)
    reference = CharField(
        column_name='x_ref', max_length=35, constraints=[SQL("DEFAULT ''")], default='')
    ucd = CharField(
        column_name='x_ucd', max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    lot = CharField(
        column_name='x_lot', max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    date_peremption = DateTimeField(
        column_name='x_tperemp',
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    fraction = IntegerField(
        column_name='x_fraction', constraints=[SQL("DEFAULT 0")], default=0)
    datalu = CharField(
        column_name='x_datalu', max_length=100, constraints=[SQL("DEFAULT ''")], default='')
    dfnum = SmallIntegerField(
        column_name='x_dfnum', constraints=[SQL("DEFAULT 0")], default=0)

    class Meta:
        table_name = 'f_histo_blocage'
        indexes = (
            (('x_chrono',), False),
            (('x_adr',), False),
            (('x_bloque',), False),
        )


class HistoriqueCoupe(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")], default=datetime.datetime.now)
    reference = CharField(
        column_name='x_ref', null=True, max_length=35, constraints=[SQL("DEFAULT ''")], default='')
    designation = CharField(
        column_name='x_desig', null=True, max_length=100, constraints=[SQL("DEFAULT ''")], default='')
    quantite_mouvement = IntegerField(
        column_name='x_qte_mvt', null=True, constraints=[SQL("DEFAULT 0")], default=0)
    fraction = IntegerField(
        column_name='x_fraction', constraints=[SQL("DEFAULT 100")], default=100)
    magasin = CharField(
        column_name='x_mag', null=True, constraints=[SQL("DEFAULT ''")])

    class Meta:
        table_name = 'f_histo_coupe'
        indexes = (
            (('x_chrono',), False),
            (('x_fraction',), False),
            (('x_ref',), False),
        )


class HistoriqueIdentification(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono',
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")], default=datetime.datetime.now)
    user = CharField(
        column_name='x_user', max_length=60, constraints=[SQL("DEFAULT ''")], default='')
    demande = CharField(
        column_name='x_demande', max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    liste = CharField(
        column_name='x_liste', max_length=60, constraints=[SQL("DEFAULT ''")], default='')

    class Meta:
        table_name = 'f_histo_identification'
        indexes = (
            (('x_chrono',), False),
            (('x_user',), False),
        )


class HistoriqueMultidoses(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono',
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")], default=datetime.datetime.now)
    reference = CharField(
        column_name='x_ref', max_length=35, constraints=[SQL("DEFAULT ''")], default='')
    quantite_servi = FloatField(
        column_name='x_qte_serv', constraints=[SQL("DEFAULT 0.000")], default=0.0)
    quantite_demande = FloatField(
        column_name='x_qte_dem', constraints=[SQL("DEFAULT 0.000")], default=0.0)
    service = CharField(
        column_name='x_dest', max_length=30, constraints=[SQL("DEFAULT ''")], default='')
    ipp = CharField(
        column_name='x_ipp', max_length=30,
        constraints=[SQL("DEFAULT ''")], default='')
    sejour = CharField(
        column_name='x_sejour', max_length=35,
        constraints=[SQL("DEFAULT ''")], default='')
    liste = CharField(
        column_name='x_liste', max_length=35,
        constraints=[SQL("DEFAULT ''")], default='')
    coef_conversion = FloatField(
        column_name='x_coef_conv', constraints=[SQL("DEFAULT 0.000")], default=0.0)
    unite_gestion = CharField(
        column_name='x_unit_gest', max_length=20,
        constraints=[SQL("DEFAULT ''")], default='')
    unite_administration = CharField(
        column_name='x_unit_admin', max_length=20,
        constraints=[SQL("DEFAULT ''")], default='')
    delai_peremption = IntegerField(
        column_name='x_delai_peremp', constraints=[SQL("DEFAULT 0")], default=0)
    date_prise = DateTimeField(
        column_name='x_dtprise', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])

    class Meta:
        table_name = 'f_histo_multidoses'
        indexes = (
            (('x_chrono',), False),
        )


class HistoriquePilulier(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono',
        constraints=[SQL("DEFAULT CURRENT_TIMESTAMP")], default=datetime.datetime.now)
    poste = CharField(
        column_name='x_poste', max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    utilisateur = CharField(
        column_name='x_user', max_length=60, constraints=[SQL("DEFAULT ''")], default='')
    pilulier = CharField(
        column_name='x_pilulier', max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    liste = CharField(
        column_name='x_liste', max_length=60, constraints=[SQL("DEFAULT ''")], default='')
    peigne = CharField(
        column_name='x_peigne', max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    erreur_pricer = BooleanField(
        column_name='x_erreur_pricer', constraints=[SQL("DEFAULT 0")], default=0)
    conf_pricer = BooleanField(
        column_name='x_conf_pricer', constraints=[SQL("DEFAULT 0")], default=0)

    class Meta:
        table_name = 'f_histo_pilulier'
        indexes = (
            (('x_chrono',), False),
            (('x_pilulier',), False),
            (('x_liste',), False),
        )


class HistoriquePlateau(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', null=True,
        constraints=[SQL("DEFAULT CURRENT_TIMESTAMP")], default=datetime.datetime.now)
    id_plateau = IntegerField(
        column_name='x_id_plateau', null=True,
        constraints=[SQL("DEFAULT 0")], default=0)
    adresse_plateau = CharField(
        column_name='x_adr_plateau', null=True, max_length=19,
        constraints=[SQL("DEFAULT ''")], default='')
    compte_rendu = IntegerField(
        column_name='x_compte_rendu', null=True,
        constraints=[SQL("DEFAULT 0")], default=0)

    class Meta:
        table_name = 'f_histo_plateau'
        indexes = (
            (('x_chrono',), False),
            (('x_id_plateau',), False),
            (('x_adr_plateau',), False),
        )


class HistoriquePrise(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono',
        constraints=[SQL("DEFAULT CURRENT_TIMESTAMP")], default=datetime.datetime.now)
    reference = CharField(
        column_name='x_ref', max_length=35, constraints=[SQL("DEFAULT ''")], default='')
    quantite_servi = FloatField(
        column_name='x_qte_serv', constraints=[SQL("DEFAULT 0.000")], default=0.0)
    quantite_demande = FloatField(
        column_name='x_qte_dem', constraints=[SQL("DEFAULT 0.000")], default=0.0)
    service = CharField(
        column_name='x_dest', max_length=30, constraints=[SQL("DEFAULT ''")], default='')
    ipp = CharField(
        column_name='x_ipp', max_length=35, constraints=[SQL("DEFAULT ''")], default='')
    sejour = CharField(
        column_name='x_sejour', max_length=35, constraints=[SQL("DEFAULT ''")], default='')
    liste = CharField(
        column_name='x_liste', max_length=60, constraints=[SQL("DEFAULT ''")], default='')
    coef_conversion = FloatField(
        column_name='x_coef_conv', constraints=[SQL("DEFAULT 0.000")], default=0.0)
    unite_gestion = CharField(
        column_name='x_unit_gest', max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    unite_administration = CharField(
        column_name='x_unit_admin', max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    delai_peremption = IntegerField(
        column_name='x_delai_peremp', constraints=[SQL("DEFAULT 0")], default=0)
    info = CharField(
        column_name='x_info1', max_length=50, constraints=[SQL("DEFAULT ''")], default='')

    class Meta:
        table_name = 'f_histo_prise'
        indexes = (
            (('x_chrono',), False),
            (('x_ref',), False),
            (('x_dest',), False),
        )


class HistoriqueSachet(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', null=True,
        constraints=[SQL("DEFAULT CURRENT_TIMESTAMP")], default=datetime.datetime.now)
    serial = CharField(
        column_name='x_serial', max_length=20, null=True, default='')
    contenant = CharField(
        column_name='x_contenant', max_length=20, null=True, default='')
    type_mouvement = CharField(
        column_name='x_type_mvt', max_length=1, null=True, default='')
    pk_item = IntegerField(
        column_name='x_pk_item', constraints=[SQL("DEFAULT 0")], default=0)
    id_plateau = IntegerField(
        column_name='x_id_plateau', constraints=[SQL("DEFAULT 0")], default=0)

    class Meta:
        table_name = 'f_histo_sachet'
        indexes = (
            (('x_chrono',), False),
            (('x_serial',), False),
            (('x_id_plateau',), False),
            (('x_pk_item',), False),
            (('x_type_mvt',), False),
        )
