from peewee import SQL
from peewee import IntegerField, CharField, AutoField
from ..base import BaseModel


class Config(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    ref_id = CharField(
        column_name='x_id', null=True,
        constraints=[SQL("DEFAULT ''")])
    poste = CharField(
        column_name='x_poste', null=True,
        constraints=[SQL("DEFAULT ''")])
    cle = CharField(
        column_name='x_cle', null=True,
        constraints=[SQL("DEFAULT ''")])
    propriete = CharField(
        column_name='x_prop', null=True,
        constraints=[SQL("DEFAULT ''")])
    type_value = CharField(
        column_name='x_type', null=True,
        constraints=[SQL("DEFAULT ''")])
    value = CharField(
        column_name='x_val', null=True,
        constraints=[SQL("DEFAULT ''")])
    hierarchie_menu = CharField(
        column_name='x_lib_tree', null=True,
        constraints=[SQL("DEFAULT ''")])
    type_champ = CharField(
        column_name='x_chp_type', null=True,
        constraints=[SQL("DEFAULT ''")])
    info_champ = CharField(
        column_name='x_chp_info', null=True,
        constraints=[SQL("DEFAULT ''")])
    ordre = IntegerField(
        column_name='x_ordre', null=True,
        constraints=[SQL("DEFAULT 0")])
    prive = IntegerField(
        column_name='x_prive', null=True,
        constraints=[SQL("DEFAULT 0")])

    class Meta:
        table_name = 'f_config'
