from peewee import IntegerField, CharField, DateTimeField, FloatField
from ..base import BaseModelSuiviProd
from peewee import SQL


class SuiviProd(BaseModelSuiviProd):

    pk = IntegerField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', default='0000-00-00 00:00:00')
    variable = CharField(
        unique=True, column_name='x_variable')
    valeur_alpha = CharField(
        column_name='x_valeur_alpha')
    valeur_num = FloatField(
        column_name="x_valeur_num", null=True, constraints=[SQL("DEFAULT 0")])
    poste = CharField(
        column_name='x_poste')
    type = CharField(
        column_name='x_type')
    etat = CharField(
        column_name='x_etat', default='')

    class Meta:
        table_name = 'f_suivi_production'


class SuiviProdMinutes(BaseModelSuiviProd):

    chrono = DateTimeField(
        column_name='x_chrono', default='0000-00-00 00:00:00')
    variable = CharField(
        unique=True, column_name='x_variable')
    valeur_alpha = CharField(
        column_name='x_valeur_alpha')
    valeur_num = FloatField(
        column_name="x_valeur_num", null=True, constraints=[SQL("DEFAULT 0")])
    poste = CharField(
        column_name='x_poste')
    type = CharField(
        column_name='x_type')
    etat = CharField(
        column_name='x_etat', default='')

    class Meta:
        table_name = 'v_minutes'


class Cadence_Pilulier_Par_Service(BaseModelSuiviProd):

    pk = IntegerField(
        column_name='x_pk', primary_key=True)
    service = CharField(
        unique=True, column_name='x_nomservice')
    heure_debut = CharField(
        column_name='x_heuredebut')
    duree = CharField(
        column_name='x_duree')
    temps_arret = CharField(
        column_name='x_tempsarret')
    nbproduit = IntegerField(
        column_name='x_nbproduit')
    nbproduitheure = IntegerField(
        column_name='x_nbproduitheure')
    nbpilulier = IntegerField(
        column_name='x_nbpilullier')
    nbpilulierheure = IntegerField(
        column_name='x_nbpilullierheure')
    nbplateau = IntegerField(
        column_name='x_nbplateau')
    nbplateauheure = IntegerField(
        column_name='x_nbplateauheure')
    poste = CharField(
        column_name='x_poste')
    chrono = DateTimeField(
        column_name='x_chrono', default='0000-00-00 00:00:00')
    index = IntegerField(
        column_name='x_index')

    class Meta:
        table_name = 'f_cadence_cueillette_pil'


class Cadence_Carnet_Par_Service(BaseModelSuiviProd):

    pk = IntegerField(
        column_name='x_pk', primary_key=True)
    service = CharField(
        unique=True, column_name='x_nomservice')
    heure_debut = CharField(
        column_name='x_heuredebut')
    duree = CharField(
        column_name='x_duree')
    temps_arret = CharField(
        column_name='x_tempsarret')
    nbcarnet = IntegerField(
        column_name='x_nb_carnet')
    nbcarnetheure = IntegerField(
        column_name='x_nb_carnetheure')
    nbproduit = IntegerField(
        column_name='x_nbproduit')
    nbproduitheure = IntegerField(
        column_name='x_nbproduitheure')
    nbpilulier = IntegerField(
        column_name='x_nbpilullier')
    nbpilulierheure = IntegerField(
        column_name='x_nbpilullierheure')
    nbplateau = IntegerField(
        column_name='x_nbplateau')
    nbplateauheure = IntegerField(
        column_name='x_nbplateauheure')
    poste = CharField(
        column_name='x_poste')
    chrono = DateTimeField(
        column_name='x_chrono', default='0000-00-00 00:00:00')
    index = IntegerField(
        column_name='x_index')

    class Meta:
        table_name = 'f_cadence_cueillette_carnet'


class CompteurJour(BaseModelSuiviProd):
    pk = IntegerField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', default='0000-00-00 00:00:00')
    poste = CharField(column_name='x_poste')
    goulotte = IntegerField(column_name='x_Goulotte')
    coupe = IntegerField(column_name='x_Coupe')
    boitePassCP = IntegerField(column_name='x_BoitePassCP')
    barillet = IntegerField(column_name='x_Barillet')
    boitePassBarillet = IntegerField(column_name='x_BoitePassBarillet')
    chargement = IntegerField(column_name='x_Chargement')
    boiteStock = IntegerField(column_name='x_BoiteStock')
    boitePrepaDir = IntegerField(column_name='x_BoitePrepaDir')

    boiteRejetDpdE1 = IntegerField(column_name='x_BoiteRejetDpdE1')
    boiteRejetDlectE1 = IntegerField(column_name='x_BoiteRejetDlectE1')
    boiteRejetDAxeE1 = IntegerField(column_name='x_BoiteRejetDAxeE1')
    boiteRejetDpsE1 = IntegerField(column_name='x_BoiteRejetDpsE1')
    boiteRejetTestE1 = IntegerField(column_name='x_BoiteRejetTestE1')
    boiteRejetErrTestE1 = IntegerField(column_name='x_BoiteRejetErrTestE1')

    boiteRejetDpdE2 = IntegerField(column_name='x_BoiteRejetDpdE2')
    boiteRejetDlectE2 = IntegerField(column_name='x_BoiteRejetDlectE2')
    boiteRejetDAxeE2 = IntegerField(column_name='x_BoiteRejetDAxeE2')
    boiteRejetDpsE = IntegerField(column_name='x_BoiteRejetDpsE2')
    boiteRejetTestE2 = IntegerField(column_name='x_BoiteRejetTestE2')
    boiteRejetErrTestE2 = IntegerField(column_name='x_BoiteRejetErrTestE2')

    class Meta:
        table_name = 'f_compteur_du_jour'
        indexes = (
            (('x_poste', 'x_chrono'), False),
        )
