# flake8: noqa
import pytest
from peewee import DoesNotExist
from median.models import Prescription, PrescriptionItem
import time
from datetime import datetime


class TestModelPrescription:
    def test_unknown_Prescription(self):
        """Test d'un Prescription inexistant"""
        with pytest.raises(DoesNotExist):
            Prescription.get(ordre="INCONNU")

    def test_create_prescription(self):
        """Test de creation d'un prescription"""
        presc = Prescription()
        presc.ordre = "Prescription 1"
        presc.ipp = "ECO1234"
        presc.sejour = "SEJ1234"
        presc.nom = "Test"
        presc.prenom = "Utilsiateur"
        presc.save()
        assert presc.pk > 0
        presc.delete_instance()

    def test_create_prescription_item(self):
        """Test de creation d'un prescription avec un item"""
        presc = Prescription()
        presc.ordre = "Prescription 1"
        presc.ipp = "ECO1234"
        presc.sejour = "SEJ1234"
        presc.nom = "Test"
        presc.prenom = "Utilsiateur"
        presc.save()
        assert presc.pk > 0
        item = PrescriptionItem()
        item.ordre = presc.ordre
        item.sejour = presc.sejour
        item.ipp = presc.ipp
        item.service = "9999"
        item.reference = "DEVERMINAGE"
        item.date_debut = datetime.now()
        item.date_fin = datetime.now()
        item.posologie = "1 matin, midi, soir"
        item.save()
        assert item.pk > 0
        item.delete_instance()
        presc.delete_instance()
