# flake8: noqa
import pytest
from peewee import DoesNotExist, IntegrityError
from median.models import Poste
import time
from datetime import datetime


class TestModelPoste:
    def test_unknown_poste(self):
        """Test d'un poste inexistant"""
        with pytest.raises(DoesNotExist):
            Poste.get(poste="INCONNU")

    def test_create_poste(self):
        """Create a poste"""
        pos = Poste()
        pos.poste = "ASTUS_99"
        pos.pc = "SERVEUR"
        pos.save()
        assert pos.pk > 0
        pos.delete_instance()

    def test_duplicate_create_poste(self):
        """Create a poste 2 times"""
        pos = Poste()
        pos.poste = "ASTUS_99"
        pos.pc = "SERVEUR"
        pos.save()
        assert pos.pk > 0

        with pytest.raises(IntegrityError):
            pos1 = Poste()
            pos1.poste = pos.poste
            pos1.pc = pos.pc
            pos1.save()

        pos.delete_instance()
