from peewee import SQL
from peewee import AutoField, CharField

from ..base import BaseModel


class Unite(BaseModel):

    pk = AutoField(column_name='x_pk', primary_key=True)
    unite = CharField(
        column_name='x_unite', max_length=10, constraints=[SQL("DEFAULT ''")]
    )
    libelle = CharField(
        column_name='x_lib_unit', max_length=20, constraints=[SQL("DEFAULT ''")]
    )

    class Meta:
        table_name = 'f_unite'
        indexes = (
            ('x_unite',), True,
            ('x_lib_unit',), False,
        ),
