from peewee import AutoField, CharField, IntegerField
from peewee import SQL

from ..base import InnodbModel


class Label(InnodbModel):
    pk = AutoField(column_name="x_pk", primary_key=True)
    code = CharField(column_name="x_code", constraints=[SQL("DEFAULT ''")])
    libelle = CharField(column_name="x_libelle", constraints=[SQL("DEFAULT ''")])
    libelle_0 = CharField(column_name="x_libelle_0", constraints=[SQL("DEFAULT ''")])
    libelle_1 = CharField(column_name="x_libelle_1", constraints=[SQL("DEFAULT ''")])
    readonly = IntegerField(column_name="x_readonly", constraints=[SQL("DEFAULT 0")], default=0)
    max_size = IntegerField(column_name="x_max_size", constraints=[SQL("DEFAULT 1")], default=1)
    order = IntegerField(column_name="x_order", constraints=[SQL("DEFAULT 0")], default=0, null=False)

    class Meta:
        table_name = "f_libelles"
        indexes = (
            (("x_code",), True),
            (("x_libelle_0",), False),
            (("x_libelle_1",), False),
        )
