from peewee import SQL, IntegerField
from peewee import AutoField, CharField

from ..base import InnodbModel


class Format(InnodbModel):
    pk = AutoField(column_name='x_pk', primary_key=True)
    format = CharField(column_name='x_format', max_length=10, constraints=[SQL("DEFAULT ''")])
    orient = CharField(column_name='x_orient', max_length=1, constraints=[SQL("DEFAULT 'Y'")], default='Y')
    mm_x = IntegerField(column_name='x_mm_x', constraints=[SQL("DEFAULT 0")], default=0)
    mm_y = IntegerField(column_name='x_mm_y', constraints=[SQL("DEFAULT 0")], default=0)
    mm_z = IntegerField(column_name='x_mm_z', constraints=[SQL("DEFAULT 0")], default=0)
    nb_div = IntegerField(column_name='x_nb_div', null=True, constraints=[SQL("DEFAULT 1")], default=1)
    dim_x = IntegerField(column_name='x_dim_x', constraints=[SQL("DEFAULT 0")], default=0)
    dim_y = IntegerField(column_name='x_dim_y', constraints=[SQL("DEFAULT 0")], default=0)
    dim_z = IntegerField(column_name='x_dim_z', constraints=[SQL("DEFAULT 0")], default=0)
    couleur = IntegerField(column_name='x_couleur', constraints=[SQL("DEFAULT 0")], default=0)
    typeBac = CharField(column_name='x_type_bac', max_length=10, constraints=[SQL("DEFAULT ''")], default='')

    class Meta:
        indexes = (('x_format',), True),
        table_name = 'f_format'


class MagasinFormat(InnodbModel):
    pk = AutoField(column_name='x_pk', primary_key=True)
    format = CharField(column_name='x_format', null=False, max_length=10, constraints=[SQL("DEFAULT ''")])
    magasin = CharField(
        column_name='x_mag', null=False, max_length=3, constraints=[SQL("DEFAULT ''")])

    class Meta:
        indexes = (
            (('x_format', 'x_mag'), True),
            (('x_format',), False),
            (('x_mag',), False),
        )
        table_name = 'f_mag_format'
