from peewee import SQL, IntegerField, BooleanField
from peewee import AutoField, CharField

from ..base import InnodbModel


class CatalogType(InnodbModel):
    pk = AutoField(column_name='x_pk', primary_key=True)
    type = CharField(column_name='x_type', max_length=20, unique=True, constraints=[SQL("DEFAULT ''")])
    eco_type = CharField(column_name="x_eco_type", constraints=[SQL("DEFAULT ''")])
    isDisable = BooleanField(
        column_name='x_disable', null=True, constraints=[SQL("DEFAULT 0")], default=0)

    class Meta:
        table_name = 'f_catalog_type'


class CatalogVersion(InnodbModel):
    pk = AutoField(column_name='x_pk', primary_key=True)
    type_pk = IntegerField(column_name='x_type_pk', null=True, default=None)
    numVersion = CharField(column_name='x_num_version', max_length=20, constraints=[SQL("DEFAULT ''")])
    subVersion = CharField(column_name='sub_version', max_length=20, constraints=[SQL("DEFAULT ''")])
    isDisable = BooleanField(
        column_name='x_disable', null=True, constraints=[SQL("DEFAULT 0")], default=0)

    class Meta:
        table_name = 'f_catalog_version'


class CatalogOption(InnodbModel):
    pk = AutoField(column_name='x_pk', primary_key=True)
    version_pk = IntegerField(column_name='x_version_pk', null=True, default=None)
    type = CharField(column_name='x_type', max_length=20, constraints=[SQL("DEFAULT ''")])
    value = IntegerField(column_name='x_value', constraints=[SQL("DEFAULT 0")], default=0)

    class Meta:
        table_name = 'f_catalog_option'


class CatalogUnitStock(InnodbModel):
    pk = AutoField(column_name='x_pk', primary_key=True)
    version_pk = IntegerField(column_name='x_version_pk', null=True, default=None)
    total_line = IntegerField(column_name='x_total_line', constraints=[SQL("DEFAULT 0")], default=0)
    total_colonne = IntegerField(column_name='x_total_colonne', constraints=[SQL("DEFAULT 0")], default=0)
    order = IntegerField(column_name='x_order', constraints=[SQL("DEFAULT 0")], default=0)

    class Meta:
        table_name = 'f_catalog_unitstock'


class CatalogLines(InnodbModel):
    pk = AutoField(column_name='x_pk', primary_key=True)
    unit_stock_pk = IntegerField(column_name='x_unit_stock_pk', null=True, default=None)
    start_line = IntegerField(column_name='x_start_line', constraints=[SQL("DEFAULT 0")], default=0)
    end_line = IntegerField(column_name='x_end_line', constraints=[SQL("DEFAULT 0")], default=0)

    class Meta:
        table_name = 'f_catalog_lines'


class CatalogColumns(InnodbModel):
    pk = AutoField(column_name='x_pk', primary_key=True)
    line_pk = IntegerField(column_name='x_line_pk', null=True, default=None)
    start_column = IntegerField(column_name='x_start_column', constraints=[SQL("DEFAULT 0")], default=0)
    end_Column = IntegerField(column_name='x_end_Column', constraints=[SQL("DEFAULT 0")], default=0)
    container_type = CharField(column_name='x_container_type', max_length=20, constraints=[SQL("DEFAULT ''")])

    class Meta:
        table_name = 'f_catalog_columns'
