# flake8: noqa
import pytest
from median.constant import (
    TypeListe, TypeServiListe, EtatListe, ExternalMachineType,
    BoxesMachineType, PlusMachineType, TrackMachineType, DpmType,
    TypeMouvementGpao)


class TestConstant:
    def test_type_liste_entree(self):
        assert TypeListe.Input.value == "E"

    def test_type_liste_sortie(self):
        assert TypeListe.Output.value == "S"

    def test_type_liste_inventaire(self):
        assert TypeListe.Inventory.value == "I"

    def test_type_liste_inventaire(self):
        assert TypeListe.Completion.value == "C"

    def test_type_servi_gloabl_boite(self):
        assert TypeServiListe.GlobaleBoite.value == "GLOBAL_BTE"

    def test_type_servi_gloabl_pilulier(self):
        assert TypeServiListe.GlobalePilulier.value == "GLOBAL_PIL"

    def test_type_servi_nominatif(self):
        assert TypeServiListe.Nominatif.value == "NOMINATIF"

    def test_type_servi_exotique(self):
        assert TypeServiListe.Exotique.value == "EXOTIQUE"

    def test_type_servi_externe(self):
        assert TypeServiListe.ExterneBoite.value == "EXTERN_BTE"

    def test_type_servi_aide_track_boite(self):
        assert TypeServiListe.AideTrackBoite.value == "TRACK_BTE"

    def test_type_servi_aide_plus_nominatif(self):
        assert TypeServiListe.AidePlusNominatif.value == "PLUS_NOM"

    def test_type_servi_aide_plus_boite(self):
        assert TypeServiListe.AidePlusBoite.value == "PLUS_BTE"

    def test_etat_liste_vierge(self):
        assert EtatListe.Vierge.value == "V"

    def test_etat_liste_encours(self):
        assert EtatListe.EnCours.value == "E"

    def test_etat_liste_solder(self):
        assert EtatListe.Solde.value == "S"

    def test_etat_liste_incident(self):
        assert EtatListe.Incident.value == "I"

    def test_etat_liste_archive(self):
        assert EtatListe.Archive.value == "Z"

    def test_etat_liste_picking(self):
        assert EtatListe.Picking.value == "P"

    def test_etat_liste_annuler(self):
        assert EtatListe.Annuler.value == "A"

    def test_boxes_machine_type_aide(self):
        assert BoxesMachineType.Aide_Box.value == "AIDE_BOX"

    def test_externe_type_machine_etagere(self):
        assert ExternalMachineType.Etagere.value == "ETAGERE"

    def test_externe_type_machine_chariot(self):
        assert ExternalMachineType.Chariot.value == "CHARIOT"

    def test_externe_type_machine_omnicell(self):
        assert ExternalMachineType.Omnicell.value == "OMNICELL"

    def test_aideplus_type_machine_medianweb(self):
        assert PlusMachineType.MedianWeb.value == "PLUS_WEB"

    def test_aideplus_type_machine_version1(self):
        assert PlusMachineType.Aide_V1.value == "PLUS_V1"

    def test_aidetrack_type_machine_version1(self):
        assert TrackMachineType.Aide_V1.value == "TRACK_V1"

    def test_dpm_type_zero(self):
        assert DpmType.Zero.value == "0"

    def test_dpm_type_pince(self):
        assert DpmType.Pince.value == "P"

    def test_dpm_type_ventouse(self):
        assert DpmType.Ventouse.value == "V"

    def test_dpm_type_track(self):
        assert DpmType.Track.value == "K"

    def test_gpao_movement_transfert(self):
        assert TypeMouvementGpao.TRANSFERT.value == 'T'

    def test_gpao_movement_inventory(self):
        assert TypeMouvementGpao.LOST_OR_RETURN.value == 'I'

    def test_gpao_movement_stock_inventory(self):
        assert TypeMouvementGpao.STOCK_INVENTORY.value == 'K'

    def test_gpao_movement_complement(self):
        assert TypeMouvementGpao.COMPLEMENT.value == 'D'

    def test_gpao_movement_replenishment(self):
        assert TypeMouvementGpao.REPLENISHMENT.value == 'R'

    def test_gpao_movement_output(self):
        assert TypeMouvementGpao.OUTPUT.value == 'S'

    def test_gpao_movement_input(self):
        assert TypeMouvementGpao.INPUT.value == 'E'
