from datetime import datetime

from peewee import AutoField, DateTimeField, CharField, SQL

from median.base import BaseModel


class UnitDose(BaseModel):
    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', null=True,
        constraints=[SQL("DEFAULT CURRENT_TIMESTAMP")], default=datetime.now)
    serial = CharField(
        column_name='x_serial', max_length=20, null=True, default='')
    contenant = CharField(
        column_name='x_contenant', max_length=20, null=True, default='')

    class Meta:
        table_name = 'f_sachet'
        indexes = (
            (('x_chrono',), False),
            (('x_serial',), False),
            (('x_contenant',), False),
        )
