DELIMITER $$

DROP PROCEDURE IF EXISTS sp_add_subservices$$

CREATE PROCEDURE sp_add_subservices(
    IN p_parent_code VARCHAR(255),
    IN p_child_code_1 VARCHAR(255),
    IN p_child_code_2 VARCHAR(255),
    IN p_child_code_3 VARCHAR(255)
)
BEGIN
    DECLARE v_parent_pk INT;
    DECLARE v_child_pk INT;
    DECLARE v_status_1 VARCHAR(50) DEFAULT '';
    DECLARE v_status_2 VARCHAR(50) DEFAULT '';
    DECLARE v_status_3 VARCHAR(50) DEFAULT '';
    DECLARE v_msg_1 VARCHAR(255) DEFAULT '';
    DECLARE v_msg_2 VARCHAR(255) DEFAULT '';
    DECLARE v_msg_3 VARCHAR(255) DEFAULT '';

    -- Get parent PK
    SELECT x_pk INTO v_parent_pk
    FROM f_dest
    WHERE x_dest COLLATE utf8mb4_general_ci = p_parent_code COLLATE utf8mb4_general_ci
      AND x_type_dest = 'SERVICE'
    LIMIT 1;

    -- Check if parent exists
    IF v_parent_pk IS NULL THEN
        SIGNAL SQLSTATE '45000'
        SET MESSAGE_TEXT = 'Parent service not found!';
    END IF;

    -- Process child 1
    IF p_child_code_1 IS NOT NULL AND p_child_code_1 != '' THEN
        SET v_child_pk = NULL;
        SELECT x_pk INTO v_child_pk
        FROM f_dest
        WHERE x_dest COLLATE utf8mb4_general_ci = p_child_code_1 COLLATE utf8mb4_general_ci
          AND x_type_dest = 'SERVICE'
        LIMIT 1;

        IF v_child_pk IS NOT NULL THEN
            INSERT INTO f_data_dest (x_dest_pk, x_subdest_pk, x_actif)
            VALUES (v_parent_pk, v_child_pk, 1)
            ON DUPLICATE KEY UPDATE x_actif = 1;

            SET v_status_1 = '✓ SUCCESS';
            SET v_msg_1 = 'Link created/updated';
        ELSE
            SET v_status_1 = '✗ FAILED';
            SET v_msg_1 = 'Child service not found';
        END IF;
    END IF;

    -- Process child 2
    IF p_child_code_2 IS NOT NULL AND p_child_code_2 != '' THEN
        SET v_child_pk = NULL;
        SELECT x_pk INTO v_child_pk
        FROM f_dest
        WHERE x_dest COLLATE utf8mb4_general_ci = p_child_code_2 COLLATE utf8mb4_general_ci
          AND x_type_dest = 'SERVICE'
        LIMIT 1;

        IF v_child_pk IS NOT NULL THEN
            INSERT INTO f_data_dest (x_dest_pk, x_subdest_pk, x_actif)
            VALUES (v_parent_pk, v_child_pk, 1)
            ON DUPLICATE KEY UPDATE x_actif = 1;

            SET v_status_2 = '✓ SUCCESS';
            SET v_msg_2 = 'Link created/updated';
        ELSE
            SET v_status_2 = '✗ FAILED';
            SET v_msg_2 = 'Child service not found';
        END IF;
    END IF;

    -- Process child 3
    IF p_child_code_3 IS NOT NULL AND p_child_code_3 != '' THEN
        SET v_child_pk = NULL;
        SELECT x_pk INTO v_child_pk
        FROM f_dest
        WHERE x_dest COLLATE utf8mb4_general_ci = p_child_code_3 COLLATE utf8mb4_general_ci
          AND x_type_dest = 'SERVICE'
        LIMIT 1;

        IF v_child_pk IS NOT NULL THEN
            INSERT INTO f_data_dest (x_dest_pk, x_subdest_pk, x_actif)
            VALUES (v_parent_pk, v_child_pk, 1)
            ON DUPLICATE KEY UPDATE x_actif = 1;

            SET v_status_3 = '✓ SUCCESS';
            SET v_msg_3 = 'Link created/updated';
        ELSE
            SET v_status_3 = '✗ FAILED';
            SET v_msg_3 = 'Child service not found';
        END IF;
    END IF;

    -- Return results as a single SELECT
    SELECT
        p_parent_code AS parent_service,
        p_child_code_1 AS child_service,
        v_status_1 AS status,
        v_msg_1 AS message
    WHERE p_child_code_1 IS NOT NULL AND p_child_code_1 != ''

    UNION ALL

    SELECT
        p_parent_code,
        p_child_code_2,
        v_status_2,
        v_msg_2
    WHERE p_child_code_2 IS NOT NULL AND p_child_code_2 != ''

    UNION ALL

    SELECT
        p_parent_code,
        p_child_code_3,
        v_status_3,
        v_msg_3
    WHERE p_child_code_3 IS NOT NULL AND p_child_code_3 != '';

END$$

DELIMITER ;