from peewee import (
    AutoField,
    CharField,
    IntegerField
)
from peewee import SQL
from ..base import BaseModelSqlView, mysql_db


class WebviewTaquin(BaseModelSqlView):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    adresse = CharField(
        column_name='x_adr', null=True)
    taquin = IntegerField(
        column_name='x_taquin', constraints=[SQL("DEFAULT 0")])
    magasin = CharField(
        column_name='x_mag', null=True, constraints=[SQL("DEFAULT ''")])

    def create_view(self):
        """Create the view in the database"""
        query = """CREATE OR REPLACE VIEW webview_taquin AS
        SELECT min(`f_adr`.`x_pk`) AS x_pk, min(`f_adr`.`x_adr`) AS `x_adr`, 2 AS `x_taquin`, `f_adr`.`x_mag`
        FROM `f_adr`
        WHERE (`f_adr`.`x_contenant` = '')
        GROUP BY LEFT(`f_adr`.`x_adr`, (LENGTH(`f_adr`.`x_adr`) - 4))
        HAVING (count(0) = 2);"""  # noqa
        mysql_db.execute_sql(query)
        # mysql_db.execute_sql("GRANT SELECT ON <database_name>.<view_name>TO <user>@<host>")

    class Meta:
        table_name = 'webview_taquin'


class WebviewDemiTaquin(BaseModelSqlView):

    pk = IntegerField(
        column_name='x_pk', constraints=[SQL("DEFAULT 0")])
    adr = CharField(
        column_name='x_adr', null=True, constraints=[SQL("DEFAULT ''")])
    demi_taquin = IntegerField(
        column_name='x_demi_taquin', constraints=[SQL("DEFAULT 0")])
    mag = CharField(
        column_name='x_mag', null=True, constraints=[SQL("DEFAULT ''")])

    def create_view(self):
        """Create the view in the database"""
        query="""CREATE OR REPLACE VIEW webview_demi_taquin AS
                SELECT `f_adr`.`x_pk` AS `x_pk`, `f_adr`.`x_adr` AS `x_adr`, 2 AS `x_demi_taquin`, `f_adr`.`x_mag`
                FROM `f_adr`
                WHERE (`f_adr`.`x_format` <> 'BAC')
                GROUP BY LEFT(`f_adr`.`x_adr`,(LENGTH(`f_adr`.`x_adr`) - 4))
                HAVING ((count(0) = 2)
                    AND (max(`f_adr`.`x_contenant`) <> '')
                        AND (min(`f_adr`.`x_contenant`) = ''))
                ORDER BY `f_adr`.`x_adr`;"""  # noqa
        mysql_db.execute_sql(query)

    class Meta:
        table_name = 'webview_demi_taquin'
