# flake8: noqa
import pytest
from peewee import DoesNotExist, IntegrityError
from median.models import Product, Service, ReferencePerService
from median.views import Seuil as vSeuil
from median.base import BaseViewException


@pytest.fixture()
def rectest():
    print("Running method level setUp")
    rec_data = {}

    p1 = Product(reference="REAP0001", designation="Produit reappro 1")
    p1.save()
    rec_data["p1"] = p1

    w1 = Service(code="0001", libelle="Service 1", type_dest="SERVICE")
    w1.save()
    rec_data["w1"] = w1

    yield rec_data
    print("Running method level tearDown")
    w1.delete_instance()
    p1.delete_instance()

def test_link_product_ward(rectest):

    rps = ReferencePerService()
    rps.ref_pk = rectest['p1'].pk
    rps.dest_pk = rectest['w1'].pk
    rps.save()
    assert rps.pk > 0
    rps.delete_instance()

def test_link_product_ward_wrong_ref(rectest):

    with pytest.raises(IntegrityError) as e:
        rps = ReferencePerService()
        rps.ref_pk = 0
        rps.dest_pk = rectest['w1'].pk
        rps.save()
    assert "a foreign key constraint fails" in str(e)

def test_link_product_ward_wrong_ward(rectest):

    with pytest.raises(IntegrityError) as e:
        rps = ReferencePerService()
        rps.ref_pk = rectest['p1'].pk
        rps.dest_pk = 0
        rps.save()
    assert "a foreign key constraint fails" in str(e)


def test_link_product_ward_backref(rectest):

    rps = ReferencePerService()
    rps.ref_pk = rectest['p1'].pk
    rps.dest_pk = rectest['w1'].pk
    rps.save()
    assert rps.pk > 0

    pro = ReferencePerService.select(
            ReferencePerService, Product, Service
        ).join(
            Product
        ).switch(ReferencePerService).join(
            Service
        ).where(Product.pk == rectest['p1'].pk).get()

    assert pro.ref_pk.pk == rectest['p1'].pk
    assert pro.dest_pk.pk == rectest['w1'].pk

    rps.delete_instance()


