import pytest
from peewee import DoesNotExist
from median.models import Dpm, DpmAction, DpmCheck, DpmComment
from median.constant import PickingMachineType


@pytest.fixture()
def rectest():
    print("Running method level setUp")
    rec_data = {}

    d = Dpm()
    d.cip = "3400912365478"
    d.dossier = "1"
    d.type_machine = PickingMachineType.Aide_V2.value
    d.creator = "Dark Vador"
    d.save()


    rec_data['dpm1'] = d
    yield rec_data

    print("Running method level tearDown")
    d.delete_instance()

class TestDpm:
    def test_dpm(self, rectest):
        assert rectest['dpm1'].pk > 0

    def test_dpm_check(self, rectest):
        assert rectest['dpm1'].pk > 0

        chk = DpmCheck()
        chk.dpm = rectest['dpm1']
        chk.profil = "ECO-DEX"
        chk.user_pk = 1
        chk.num = 1
        chk.save()

        assert chk.pk > 0

        chk.delete_instance()

    def test_dpm_action(self, rectest):
        assert rectest['dpm1'].pk > 0

        chk = DpmCheck()
        chk.dpm = rectest['dpm1']
        chk.profil = "ECO-DEX"
        chk.user_pk = 1
        chk.num = 1
        chk.save()

        assert chk.pk > 0

        act = DpmAction()
        act.dpm_check = chk
        act.user_pk = 1
        act.num = 1
        act.is_checked = True
        act.save()

        assert act.pk > 0

        act.delete_instance()
        chk.delete_instance()


    def test_dpm_comment(self, rectest):
        assert rectest['dpm1'].pk > 0

        chk = DpmCheck()
        chk.dpm = rectest['dpm1']
        chk.profil = "ECO-DEX"
        chk.user_pk = 1
        chk.num = 1
        chk.save()

        assert chk.pk > 0

        act = DpmAction()
        act.dpm_check = chk
        act.user_pk = 1
        act.num = 1
        act.is_checked = True
        act.save()

        assert act.pk > 0

        com = DpmComment()
        com.user_pk = 1
        com.dpm_action = act
        com.comment = "Test"
        com.save()

        assert com.pk > 0

        com.delete_instance()
        act.delete_instance()
        chk.delete_instance()
