# flake8: noqa
import pytest
from median.constant import TypeListe, TypeServiListe, EtatListe, ExternalMachineType, BoxesMachineType


class TestConstant:
    def test_type_liste_entree(self):
        assert TypeListe.Input.value == "E"

    def test_type_liste_sortie(self):
        assert TypeListe.Output.value == "S"

    def test_type_servi_gloabl_boite(self):
        assert TypeServiListe.GlobaleBoite.value == "GLOBAL_BTE"

    def test_type_servi_gloabl_pilulier(self):
        assert TypeServiListe.GlobalePilulier.value == "GLOBAL_PIL"

    def test_type_servi_nominatif(self):
        assert TypeServiListe.Nominatif.value == "NOMINATIF"

    def test_type_servi_exotique(self):
        assert TypeServiListe.Exotique.value == "EXOTIQUE"

    def test_type_servi_externe(self):
        assert TypeServiListe.ExterneBoite.value == "EXTERN_BTE"        

    def test_etat_liste_vierge(self):
        assert EtatListe.Vierge.value == "V"

    def test_etat_liste_encours(self):
        assert EtatListe.EnCours.value == "E"

    def test_etat_liste_solder(self):
        assert EtatListe.Solde.value == "S"

    def test_etat_liste_incident(self):
        assert EtatListe.Incident.value == "I"

    def test_etat_liste_archive(self):
        assert EtatListe.Archive.value == "Z"

    def test_etat_liste_picking(self):
        assert EtatListe.Picking.value == "P"

    def test_etat_liste_annuler(self):
        assert EtatListe.Annuler.value == "A"

    def test_boxes_machine_type_aide(self):
        assert BoxesMachineType.Aide_Box.value == "AIDE_BOX"

    def test_externe_type_machine_etagere(self):
        assert ExternalMachineType.Etagere.value == "ETAGERE"

    def test_externe_type_machine_chariot(self):
        assert ExternalMachineType.Chariot.value == "CHARIOT"

    def test_externe_type_machine_omnicell(self):
        assert ExternalMachineType.Omnicell.value == "OMNICELL"
