from peewee import SQL
from peewee import (
    IntegerField,
    CharField,
    ForeignKeyField,
    AutoField,
    TextField
)
from ..base import InnodbModel
from .magasin import Magasin


class PrinterType(InnodbModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    name = CharField(
        column_name='x_name', null=True, max_length=32)
    lang = CharField(
        column_name='x_lang', null=True, max_length=12)
    density = IntegerField(
        column_name='x_density', null=True)
    quality = CharField(
        column_name='x_quality', null=True, max_length=50)
    unit = CharField(
        column_name='x_unit', null=True, max_length=10)

    class Meta:
        table_name = 'f_printer_model'
        indexes = (
            (('x_name',), True),
            (('x_lang',), False),
        )


class PrinterLabel(InnodbModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    name = CharField(
        column_name='x_name', null=True, max_length=100)
    width = IntegerField(
        column_name='x_width', null=True, constraints=[SQL("DEFAULT 0")], default=0)
    height = IntegerField(
        column_name='x_height', null=True, constraints=[SQL("DEFAULT 0")], default=0)

    class Meta:
        table_name = 'f_printer_label'
        indexes = (
            (('x_name',), True),
        )


class Printer(InnodbModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    name = CharField(
        column_name='x_name', null=True, max_length=32)
    type_id = ForeignKeyField(
        PrinterType, column_name='x_type_id', backref="printer_type", lazy_load=False,
        on_delete='CASCADE', on_update='CASCADE')
    address = CharField(
        column_name='x_address', null=True, max_length=100)
    current_label_id = ForeignKeyField(
        PrinterLabel, column_name='x_current_label_id', backref="label", lazy_load=False,
        on_delete='CASCADE', on_update='CASCADE')
    option_cut = IntegerField(
        column_name='x_option_cut', null=True)
    cut_trigger = IntegerField(
        column_name='x_cut_trigger', null=True, constraints=[SQL("DEFAULT 0")], default=0)

    class Meta:
        table_name = 'f_printer'
        indexes = (
            (('x_name',), True),
            # (('x_type_id',), False),
            # (('x_current_label_id',), False),
        )


class PrinterMag(InnodbModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    printer_id = ForeignKeyField(
        Printer, column_name='x_printer_id', backref="printer", lazy_load=False,
        on_delete='CASCADE', on_update='CASCADE')
    mag_id = ForeignKeyField(
        Magasin, column_name='x_mag_id', backref="magasin", lazy_load=False,
        on_delete='CASCADE', on_update='CASCADE')
    primary = IntegerField(
        column_name='x_primary', null=True, constraints=[SQL("DEFAULT 0")], default=0)

    class Meta:
        table_name = 'f_mag_printer'
        indexes = (
            (('x_printer_id', 'x_mag_id'), True),
        )


class PrinterCommand(InnodbModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    name = CharField(
        column_name='x_name', max_length=100)
    code = CharField(
        column_name='x_code', max_length=64)

    class Meta:
        table_name = 'f_printer_cmd'
        indexes = (
            (('x_code',), True),
            (('x_name',), False),
        )


class PrinterCommandLabel(InnodbModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    label_id = ForeignKeyField(
        PrinterLabel, column_name='x_label_id', backref="label",
        lazy_load=False, on_delete='CASCADE', on_update='CASCADE')
    command_id = ForeignKeyField(
        PrinterCommand, column_name='x_command_id', backref="command",
        lazy_load=False, on_delete='CASCADE', on_update='CASCADE')
    print_code = TextField(
        column_name='x_print_code')
    print_dict = TextField(
        column_name='x_print_dict')
    enabled = IntegerField(
        column_name='x_enabled', constraints=[SQL("DEFAULT 1")], default=1)

    class Meta:
        table_name = 'f_printer_cmd_label'
        indexes = (
            (('x_label_id', 'x_command_id'), True),
        )
