from peewee import AutoField, DateTimeField, CharField, SQL, IntegerField, ForeignKeyField, BooleanField, TextField
from median.base import InnodbModel
from median.database import TinyIntegerField
from datetime import datetime


class Dpm(InnodbModel):
    pk = AutoField(
        column_name='x_pk', primary_key=True)
    cip = CharField(
        column_name='x_cip', max_length=20,
        constraints=[SQL("DEFAULT ''")], default='')
    ucd = CharField(
        column_name='x_ucd', max_length=20,
        constraints=[SQL("DEFAULT ''")], default='')
    dossier = CharField(
        column_name='x_index_dossier', max_length=20,
        constraints=[SQL("DEFAULT '0'")], default="0")
    type_machine = CharField(
        column_name="x_type_machine", max_length=20,
        constraints=[SQL("DEFAULT ''")], default='')
    creation = DateTimeField(
        column_name='x_tcreation', null=True, default=datetime.now)
    creator = CharField(
        column_name='x_user_creator', null=True, max_length=20,
        constraints=[SQL("DEFAULT ''")], default='')
    creator_pk = IntegerField(
        column_name='x_creator_pk', null=True,
        default=None)
    ucd_cip = IntegerField(
        column_name='x_ucd_cip_pk', null=True,
        default=None)
    closing_date = DateTimeField(
        column_name='x_closing_date', null=True)
    closing_user_pk = IntegerField(
        column_name='x_closing_user_pk', null=True,
        default=None)
    validation_date = DateTimeField(
        column_name='x_validation_date', null=True)
    validator_pk = IntegerField(
        column_name='x_validator_pk', null=True, default=None)
    modification_date = DateTimeField(
        column_name='x_modification_date', null=True)
    modifier_pk = IntegerField(
        column_name='x_modification_pk', null=True, default=None)
    zip_file = CharField(
        column_name="x_zip_file", max_length=100,
        constraints=[SQL("DEFAULT ''")], default='')
    qt_blister = IntegerField(
        column_name='x_qt_blister', constraints=[SQL("DEFAULT 0")], default=0)
    qt_boite = IntegerField(
        column_name='x_qt_boite', constraints=[SQL("DEFAULT 0")], default=0)
    qt_pass = IntegerField(
        column_name='x_qt_pass', constraints=[SQL("DEFAULT 0")], default=0)
    DU_boite_pass = TinyIntegerField(
        column_name='x_du_boite_pass', null=True,
        constraints=[SQL("DEFAULT 0")], default=0)

    class Meta:
        table_name = 'f_dpm'
        indexes = (
            (('x_cip', 'x_index_dossier', 'x_type_machine'), True),
            (('x_type_machine',), False),
            (('x_cip',), False),
            (('x_ucd',), False),
        )


class DpmCheck(InnodbModel):
    pk = AutoField(
        column_name='x_pk', primary_key=True)
    dpm = ForeignKeyField(
        Dpm, column_name='x_pk_dpm', backref='checks',
        lazy_load=False, on_delete='CASCADE', on_update='CASCADE')
    profil = CharField(
        column_name='x_profil', max_length=20)
    user_pk = IntegerField(
        column_name='x_pk_user', null=True, default=None)
    edit_date = DateTimeField(
        column_name='x_date_edit', null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    num = IntegerField(
        column_name='x_num', null=True, default=0)
    is_checked = BooleanField(
        column_name='x_is_checked', null=True)

    class Meta:
        table_name = 'f_dpm_check'
        indexes = (
            (('x_profil',), False),
            (('x_num',), False),
        )


class DpmAction(InnodbModel):
    pk = AutoField(
        column_name='x_pk', primary_key=True)
    dpm_check = ForeignKeyField(
        DpmCheck, column_name='x_pk_dpm_check', backref='actions',
        lazy_load=False, on_delete='CASCADE', on_update='CASCADE')
    user_pk = IntegerField(
        column_name='x_pk_user', null=True, default=None)
    edit_date = DateTimeField(
        column_name='x_date_edit', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    num = IntegerField(
        column_name='x_num', null=True, default=0)
    is_checked = BooleanField(
        column_name='x_is_checked', null=True)

    class Meta:
        table_name = 'f_dpm_action'
        indexes = (
            (('x_num',), False),
            (('x_is_checked',), False),
        )


class DpmComment(InnodbModel):
    pk = AutoField(
        column_name='x_pk', primary_key=True)
    user_pk = IntegerField(
        column_name='x_pk_user', null=True, default=None)
    dpm_action = ForeignKeyField(
        DpmAction, column_name='x_pk_dpm_action', backref='comments',
        lazy_load=False, on_delete='CASCADE', on_update='CASCADE')
    creation_date = DateTimeField(
        column_name='x_date_creation', null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    comment = TextField(
        column_name='x_comment', constraints=[SQL("DEFAULT ''")],
        default='')

    class Meta:
        table_name = 'f_dpm_comment'
        indexes = (
            (('x_date_creation',), False),
        )
