from enum import Enum


class TypeListe(Enum):
    Input = 'E'
    Inventory = 'I'
    Output = 'S'


class TypeServiListe(Enum):
    GlobaleBoite = 'GLOBAL_BTE'
    GlobalePilulier = 'GLOBAL_PIL'
    Nominatif = 'NOMINATIF'
    Exotique = 'EXOTIQUE'
    RiedlBoite = 'RIEDL_BTE'     # Riedl mode
    Inventory = 'INVENTORY'      # Riedl mode
    Retour = 'RETOUR'            # Riedl mode
    Prelevement = 'PRELEV'       # Riedl mode
    RetraitLot = 'RETRAIT'       # Riedl mode
    Perimee = 'PERIMEE'          # Riedl mode
    ExterneBoite = 'EXTERN_BTE'


class EtatListe(Enum):
    Vierge = 'V'
    EnCours = 'E'
    Solde = 'S'
    Incident = 'I'
    Archive = 'Z'
    Picking = 'P'
    Annuler = 'A'


class PatientGlobal(Enum):
    Ipp = 'GLOBAL'
    Sejour = 'GLOBAL'


class EtatAdresse(Enum):
    Libre = 'L'
    Occupe = 'O'
    Bloque = 'X'
    Multiple = 'M'  # Many differents stock on the same address


class RiedlTakingMode(Enum):
    NoTakingMode = 'NO'
    OneBoxGlobalTray = 'GL'
    OneBoxTakingTray = 'PL'


class HistoryType(Enum):
    Coupe = "CPE"
    Directe = "DIR"
    Entree = "ENT"
    Inventaire = "INV"
    Liste = "LIS"
    Livraison = "LIV"
    Pilotage = "PIL"
    Reference = "REF"
    Sortie = "SOR"
    Transfert = "TFT"


class EquipmentType(Enum):
    ACCED = 'ACCED'
    ASTUS = 'ASTUS'
    AIDE = 'AIDE'
    RIEDL = "RIEDL"
    EXTERNE = "EXTERNE"


class EcoType(Enum):
    Astus = "A"
    Cueillette = "C"
    Coupe = "T"
    Riedl = "L"
    Boites = "B"
    Externe = "E"


class AstusMachineType(Enum):
    Version_1 = "ASTUS_V1"
    Version_2 = "ASTUS_V2"
    Version_3 = "ASTUS_V3"


class PickingMachineType(Enum):
    Acced_110 = "ACCED_110"
    Acced_120 = "ACCED_120"
    Acced_210 = "ACCED_210"
    Acced_220 = "ACCED_220"
    Acced_230 = "ACCED_230"
    Acced_440 = "ACCED_440"
    Acced_Boite_Pass = "ACCED_V2"
    Acced_Dose_Unit = "ACCED_V3"
    Aide_150 = "AIDE_150"
    Aide_V2 = "AIDE_V2"
    Aide_V3 = "AIDE_V3"
    Aide_Pick = "AIDE_PICK"


class RiedlMachineType(Enum):
    Riedl_Version_1 = "RIEDL_1"
    Riedl_Version_2 = "RIEDL_2"


class BoxesMachineType(Enum):
    Aide_Box = "AIDE_BOX"


class CuttingMachineType(Enum):
    Module_Coupe_500 = "MC_500"
    Module_Coupe_1000 = "MC_1000"
    Acced_110 = "ACCED_110"
    Acced_120 = "ACCED_120"
    Acced_210 = "ACCED_210"
    Acced_220 = "ACCED_220"
    Acced_320 = "ACCED_320"
    Acced_230 = "ACCED_230"
    Acced_440 = "ACCED_440"
    Aide_V2 = "AIDE_V2"
    Aide_V3 = "AIDE_V3"
    Aide_Cut = "AIDE_CUT"


class ExternalMachineType(Enum):
    Etagere = "ETAGERE"
    Chariot = "CHARIOT"
    Omnicell = "OMNICELL"


class DpmType(Enum):
    Pince = "P"
    Ventouse = "V"


DEFAULT_PROFILS = [
    'ECO-DEX',
    'DEENOVA',
    'ADMIN',
    'TECH'
]

CUSTOM_PROFILS = [
    'PREPARATEUR',
    'PHARMACIEN',
    'REFERENT',
    'INFIRMIER'
]

ACCED_TAQUIN = [
    PickingMachineType.Acced_110.value,
    PickingMachineType.Acced_120.value,
    PickingMachineType.Acced_210.value,
    PickingMachineType.Acced_220.value,
    PickingMachineType.Acced_230.value,
    PickingMachineType.Acced_440.value,
    PickingMachineType.Aide_150.value,
    PickingMachineType.Acced_Boite_Pass.value,
    PickingMachineType.Acced_Dose_Unit.value,
]

DPM_PINCE = [
    CuttingMachineType.Module_Coupe_500.value,
    CuttingMachineType.Module_Coupe_1000.value,
    CuttingMachineType.Acced_110.value,
    CuttingMachineType.Acced_120.value,
    CuttingMachineType.Acced_210.value,
    CuttingMachineType.Acced_220.value,
    CuttingMachineType.Acced_230.value,
    CuttingMachineType.Acced_320.value,
    CuttingMachineType.Acced_440.value,
    PickingMachineType.Acced_Boite_Pass.value,
]

DPM_VENTOUSE = [
    CuttingMachineType.Aide_Cut.value,
    PickingMachineType.Acced_Dose_Unit.value,
]

RIEDL_PRIORITY = [
    (1, 'Haute'),
    (3, 'Normale'),
    (5, 'Faible'),
]

RIEDL_COMPLETE = [
    (0, 'Partiel'),
    (1, 'Complète')
]

DRUGS_FRACTION = [
    25, 50,
    75, 100
]

DRUGS_ANOMALY = [
    ("UCD_DBL", "UCD on 2 drugs"),
    ("GTIN_DBL", "GTIN on 2 UCD"),
]
