# flake8: noqa
import pytest
from median.base import BaseView
from median.views import Dispensation, Items, Dispensation_Suggestion
from median.models import Service, Patient, Prescription
from median.models import ListeModel
from median.constant import TypeListe, EtatListe
import time
from datetime import datetime


@pytest.fixture()
def rectest():
    print("Running method level setUp")
    rec_data = {}
    curipp = "ABCD1234"

    pat_test = Patient(nom="Test", prenom="Patrick")
    pat_test.ipp = curipp
    pat_test.sexe = "M"
    pat_test.date_maj = datetime.now()
    pat_test.save()

    presc = Prescription()
    presc.ordre = "Prescription 1"
    presc.ipp = curipp
    presc.sejour = "SEJ1234"
    presc.nom = "Test"
    presc.prenom = "Utilsiateur"
    presc.save()

    serv = Service()
    serv.code = "9999"
    serv.libelle = "Service de test"
    serv.ordre = 0
    serv.type_dest = "SERVICE"
    serv.moment_deb = "matin"
    serv.deb_matin = 7
    serv.deb_midi = 12
    serv.deb_soir = 18
    serv.deb_coucher = 21
    serv.nb_jour = 7
    serv.save()

    dis1 = ListeModel()
    dis1.liste = "TEST dispensation"
    dis1.mode = TypeListe.Output.value
    dis1.etat = EtatListe.Vierge.value
    dis1.type_servi = "NOMINATIF"
    dis1.id_prescription = presc
    dis1.num_ipp = pat_test.ipp
    dis1.num_sej = 'SEJ1234'
    dis1.save()

    rec_data["patient"] = pat_test
    rec_data["prescription"] = presc
    rec_data["service"] = serv
    rec_data["dispensation"] = [
        dis1,
    ]

    yield rec_data

    print("Running method level tearDown")
    pat_test.delete_instance()
    presc.delete_instance()
    serv.delete_instance()
    for d in rec_data["dispensation"]:
        d.delete_instance()


class TestViewDispensation:
    def test_init_dispensationview(self):
        """
        Test d'initialisation de la classe
        """
        dsp = Dispensation()
        assert dsp is not None

    def test_list_dipensation(self, rectest):
        """Display the dispensation list"""
        dsp = Dispensation()
        res = dsp.affichage("9999", "ABCD1234", "x_liste", "desc")
        # TODO need to be fixed
        # assert len(res) == 2

    def test_list_items(self, rectest):
        """Display all items for a list"""
        itm = Items()
        res = itm.affichage("9999", "x_liste", "desc")
        # TODO need to be fixed

    def test_list_dipensation_suggest(self, rectest):
        """Display the dispensation suggestion list"""
        dsp = Dispensation_Suggestion()
        res = dsp.affichage("ABCD1234", "x_liste", "desc")
        # TODO need to be fixed
        # assert len(res) == 2
