from enum import Enum

MEDIANWEB_POSTE = "MEDIANWEB"
TOUS_POSTE = "TOUS"
CONFIG_WEB_CLE = "web"
CONFIG_CFG_CLE = "cfg"

MYSQL_ZERO_DATE = "0000-00-00 00:00:00"


class TypeListe(Enum):
    Input = 'E'
    Inventory = 'I'
    Output = 'S'
    Completion = 'C'
    OutputArchive = 'Z'


class TypeDest(Enum):
    Ward = 'SERVICE'
    Sector = 'SECTEUR'
    RiedlEndpoint = 'RIEDL'


class TypeMouvementGpao(Enum):
    INPUT = 'E'
    OUTPUT = 'S'
    REPLENISHMENT = 'R'
    COMPLEMENT = 'D'
    STOCK_INVENTORY = 'K'
    LOST_OR_RETURN = 'I'
    TRANSFERT = 'T'


class TypeEtatGpao(Enum):
    DRAFT = 'A'
    DRAFT2 = 'B'  # This is an intermediary state of draft (A)
    DONE = 'T'
    UNKNOWN = 'X'
    SETTLE = 'N'  # Solder une ligne (car qté donné = 0)
    INCIDENT = 'I'


class TypeServiListe(Enum):
    GlobaleBoite = 'GLOBAL_BTE'
    GlobalePilulier = 'GLOBAL_PIL'
    Nominatif = 'NOMINATIF'
    Exotique = 'EXOTIQUE'
    RiedlBoite = 'RIEDL_BTE'          # Riedl mode
    Inventory = 'INVENTORY'           # Riedl mode
    Retour = 'RETOUR'                 # Riedl mode
    Prelevement = 'PRELEV'            # Riedl mode
    RetraitLot = 'RETRAIT'            # Riedl mode
    Perimee = 'PERIMEE'               # Riedl mode
    AideTrackBoite = 'TRACK_BTE'      # Aide Track
    ExterneBoite = 'EXTERN_BTE'
    AidePlusNominatif = 'PLUS_NOM'    # Aide Plus
    AidePlusBoite = 'PLUS_BTE'        # Aide Plus


class ReferenceDistribution(Enum):
    Unitaire = 'UN'
    NoDistribution = 'NO'
    Fullpack = 'BO'


class ReferenceDistributionType(Enum):
    Nominative = 'N'
    Global = 'G'


class EtatListe(Enum):
    Vierge = 'V'
    EnCours = 'E'
    Solde = 'S'
    Incident = 'I'
    Archive = 'Z'
    Picking = 'P'
    Annuler = 'A'


class PatientGlobal(Enum):
    Ipp = 'GLOBAL'
    Sejour = 'GLOBAL'


class EtatAdresse(Enum):
    Libre = 'L'
    Occupe = 'O'
    Bloque = 'X'
    Multiple = 'M'  # Many differents stock on the same address
    Unlocked = 'U'  # Unlocked state, used by machines like AidePlus


class RiedlTakingMode(Enum):
    NoTakingMode = 'NO'
    OneBoxGlobalTray = 'GL'
    OneBoxTakingTray = 'PL'


class HistoryType(Enum):
    Coupe = "CPE"
    Directe = "DIR"
    Entree = "ENT"
    Inventaire = "INV"
    Liste = "LIS"
    Livraison = "LIV"
    Pilotage = "PIL"
    Reference = "REF"
    Sortie = "SOR"
    Transfert = "TFT"


class EquipmentType(Enum):
    ACCED = 'ACCED'
    ASTUS = 'ASTUS'
    AIDE = 'AIDE'
    RIEDL = "RIEDL"
    EXTERNE = "EXTERNE"
    AIDETRACK = "TRACK"
    AIDEPLUS = "PLUS"
    WAREHOUSE = "WAREHOUSE"


class EcoType(Enum):
    Astus = "A"
    Cueillette = "C"
    Return = "R"
    Coupe = "T"
    Riedl = "L"
    Boites = "B"
    Externe = "E"
    AideTrack = "K"
    AidePlus = "P"
    Unmanaged = "U"


class AstusMachineType(Enum):
    Version_1 = "ASTUS_V1"
    Version_2 = "ASTUS_V2"
    Version_3 = "ASTUS_V3"


class PickingMachineType(Enum):
    Acced_110 = "ACCED_110"  # V1
    Acced_120 = "ACCED_120"
    Acced_210 = "ACCED_210"
    Acced_220 = "ACCED_220"
    Acced_230 = "ACCED_230"
    Acced_440 = "ACCED_440"
    Aide_150 = "AIDE_150"  # end V1
    Acced_Boite_Pass = "ACCED_V2"
    Acced_Dose_Unit = "ACCED_V3"
    Aide_V2 = "AIDE_V2"
    Aide_V3 = "AIDE_V3"
    Aide_Pick = "AIDE_PICK"


class RiedlMachineType(Enum):
    Riedl_Version_1 = "RIEDL_1"
    Riedl_Version_2 = "RIEDL_2"


class BoxesMachineType(Enum):
    Aide_Box = "AIDE_BOX"


class CuttingMachineType(Enum):
    Module_Coupe_500 = "MC_500"
    Module_Coupe_1000 = "MC_1000"
    Acced_110 = "ACCED_110"
    Acced_120 = "ACCED_120"
    Acced_210 = "ACCED_210"
    Acced_220 = "ACCED_220"
    Acced_320 = "ACCED_320"
    Acced_230 = "ACCED_230"
    Acced_440 = "ACCED_440"
    Aide_V2 = "AIDE_V2"
    Aide_V3 = "AIDE_V3"
    Aide_Cut = "AIDE_CUT"


class ExternalMachineType(Enum):
    Etagere = "ETAGERE"
    Chariot = "CHARIOT"
    Omnicell = "OMNICELL"


class TrackMachineType(Enum):
    AideTrack_V1 = "TRACK_V1"


class PlusMachineType(Enum):
    MedianWeb = "PLUS_WEB"
    AidePlus_V1 = "PLUS_V1"


class DpmType(Enum):
    Zero = "0"
    Pince = "P"
    Ventouse = "V"
    Track = "K"


class ReapModes(Enum):
    Manual = 0
    Tampon = "T"  # Cut / Acced
    Track = "K"


DEFAULT_PROFILS = [
    'ECO-DEX',
    'DEENOVA',
    'ADMIN',
    'TECH'
]

CUSTOM_PROFILS = [
    'PREPARATEUR',
    'PHARMACIEN',
    'REFERENT',
    'INFIRMIER'
]

ACCED_TAQUIN = [
    PickingMachineType.Acced_110.value,
    PickingMachineType.Acced_120.value,
    PickingMachineType.Acced_210.value,
    PickingMachineType.Acced_220.value,
    PickingMachineType.Acced_230.value,
    PickingMachineType.Acced_440.value,
    PickingMachineType.Aide_150.value,
    PickingMachineType.Acced_Boite_Pass.value,
    PickingMachineType.Acced_Dose_Unit.value,
]

DPM_PINCE = [
    CuttingMachineType.Module_Coupe_500.value,
    CuttingMachineType.Module_Coupe_1000.value,
    CuttingMachineType.Acced_110.value,
    CuttingMachineType.Acced_120.value,
    CuttingMachineType.Acced_210.value,
    CuttingMachineType.Acced_220.value,
    CuttingMachineType.Acced_230.value,
    CuttingMachineType.Acced_320.value,
    CuttingMachineType.Acced_440.value,
    PickingMachineType.Acced_Boite_Pass.value,
]

DPM_VENTOUSE = [
    CuttingMachineType.Aide_Cut.value,
    PickingMachineType.Acced_Dose_Unit.value,
]

DPM_TRACK = [
    TrackMachineType.AideTrack_V1.value,
]

RIEDL_PRIORITY = [
    (1, 'Haute'),
    (3, 'Normale'),
    (5, 'Faible'),
]

RIEDL_COMPLETE = [
    (0, 'Partiel'),
    (1, 'Complète')
]

DRUGS_FRACTION = [
    25, 50,
    75, 100
]

DRUGS_ANOMALY = [
    ("UCD_DBL", "UCD on 2 drugs"),
    ("GTIN_DBL", "GTIN on 2 UCD"),
]

PRINTER_DENSITY = [
    203, 300, 600
]
