# flake8: noqa
import pytest
from median.utils import compute_gtin_checksum
from median.base import MedianLibException


class TestUtils:
    def test_compute_bad_length_checksum(self):
        with pytest.raises(MedianLibException) as e:
            chk = compute_gtin_checksum("23300100000")
        assert "GTIN must have 12 characters!" in str(e.value)

    def test_compute_empty_gtin_checksum(self):
        with pytest.raises(MedianLibException) as e:
            chk = compute_gtin_checksum("")
        assert "GTIN cannot be null" in str(e.value)

    def test_compute_good_checksum(self):
        chk = compute_gtin_checksum("233001000000")
        assert chk == "3"

    def test_compute_good_checksum_full(self):
        chk = compute_gtin_checksum("233001000000", True)
        assert chk == "2330010000003"
