# flake8: noqa
import pytest
from peewee import DoesNotExist
from median.models import Product, Seuil, Stock, Magasin, FListe, Gpao, Historique
from median.views import Seuil as vSeuil
from median.base import BaseViewException


@pytest.yield_fixture()
def rectest():
    print("Running method level setUp")
    rec_data = {}

    p1 = Product(reference="REAP0001", designation="Produit reappro 1")
    p1.save()
    rec_data["p1"] = p1

    p2 = Product(reference="REAP0002", designation="Produit reappro 2")
    p2.save()
    rec_data["p2"] = p2

    p3 = Product(reference="REAP0003", designation="Produit reappro 3")
    p3.save()
    rec_data["p3"] = p3

    m1 = Magasin(mag="MS1", type_mag="MAGSEUIL1", eco_type="C")
    m1.save()
    rec_data["m1"] = m1

    s1 = Seuil(
        reference="REAP0001",
        zone="MAGSEUIL1",
        fraction=100,
        stock_mini=10,
        stock_maxi=20,
    )
    s1.save()
    rec_data["s1"] = s1

    s2 = Seuil(
        reference="REAP0001", zone="MAGSEUIL1", fraction=50, stock_mini=5, stock_maxi=10
    )
    s2.save()
    rec_data["s2"] = s2

    s3 = Seuil(
        reference="REAP0002",
        zone="MAGSEUIL1",
        fraction=100,
        stock_mini=15,
        stock_maxi=25,
    )
    s3.save()
    rec_data["s3"] = s3

    s4 = Seuil(
        reference="REAP0002", zone="MAGSEUIL1", fraction=25, stock_mini=2, stock_maxi=5
    )
    s4.save()
    rec_data["s4"] = s4

    s5 = Seuil(
        reference="REAP0003",
        zone="MAGSEUIL1",
        fraction=100,
        stock_mini=20,
        stock_maxi=30,
    )
    s5.save()
    rec_data["s5"] = s5

    yield rec_data

    print("Running method level tearDown")
    s1.delete_instance()
    s2.delete_instance()
    s3.delete_instance()
    s4.delete_instance()
    s5.delete_instance()
    m1.delete_instance()
    p1.delete_instance()
    p2.delete_instance()
    p3.delete_instance()
    # Remove all refill list afeter the test
    refill = FListe.select().where(FListe.mode == "E", FListe.fusion == "REASSORT")
    for rf in refill:
        rf.delete_instance()

    # Remove all GPAO product
    refgp = Gpao.select().where(Gpao.type_mvt == "R")
    for rgp in refgp:
        rgp.delete_instance()

    # Remove all histories reference
    hist = Historique.select().where(Historique.type_mouvement == "REF")
    for h in hist:
        h.delete_instance()


# class TestView:

# def test_refill_list_bad_whs(self, rectest):
# """Test create refill list"""
# with pytest.raises(BaseViewException) as e:
#     seil = vSeuil()
#     seil.reappro_liste('UXX')
# assert "Le magasin n'existe pas dans la base" in str(e.value)

# def test_refill_list_with_level(self, rectest):
#     with pytest.raises(BaseViewException) as e:
#         seil = vSeuil()
#         seil.reappro_liste('ASTUS_1')

#     assert "Pas de seuil définit pour le magasin ASTUS_1" in str(e.value)

# def test_refill_list(self, rectest):
#     """Test refill mag with product level"""
#     s_euil = vSeuil()
#     lst = s_euil.reappro_liste(rectest['m1'].type_mag)
#     assert lst.liste.startswith("MAGSEUIL1") == True
#     assert lst.nb_item == 5
#     gp = Gpao.select().where(Gpao.type_mvt=='R', Gpao.etat=='A')
#     assert len(gp) == 5
#     his = Historique.select().where(Historique.type_mouvement=='REF')
#     assert len(his) == 5

#     lst.delete_instance()

# def test_refill_list_with_libelle(self, rectest):
#     """Test refill mag with product level and libelle"""
#     s_euil = vSeuil()
#     lst = s_euil.reappro_liste(rectest['m1'].type_mag, "TEST123")
#     assert lst.liste.startswith("TEST123") == True
#     assert lst.nb_item == 5
#     gp = Gpao.select().where(Gpao.type_mvt=='R', Gpao.etat=='A')
#     assert len(gp) == 5
#     his = Historique.select().where(Historique.type_mouvement=='REF')
#     assert len(his) == 5

#     lst.delete_instance()
