from peewee import IntegerField, CharField, DateTimeField
from ..base import BaseModelSuiviProd
from peewee import SQL


class SuiviProd(BaseModelSuiviProd):

    pk = IntegerField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', default='0000-00-00 00:00:00')
    variable = CharField(
        unique=True, column_name='x_variable')
    valeur_alpha = CharField(
        column_name='x_valeur_alpha')
    valeur_num = IntegerField(
        column_name="x_valeur_num", null=True, constraints=[SQL("DEFAULT 0")])
    poste = CharField(
        column_name='x_poste')
    type = CharField(
        column_name='x_type')
    etat = CharField(
        column_name='x_etat', default='')

    class Meta:
        table_name = 'f_suivi_production'


class SuiviProdMinutes(BaseModelSuiviProd):

    chrono = DateTimeField(
        column_name='x_chrono', default='0000-00-00 00:00:00')
    variable = CharField(
        unique=True, column_name='x_variable')
    valeur_alpha = CharField(
        column_name='x_valeur_alpha')
    valeur_num = IntegerField(
        column_name="x_valeur_num", null=True, constraints=[SQL("DEFAULT 0")])
    poste = CharField(
        column_name='x_poste')
    type = CharField(
        column_name='x_type')
    etat = CharField(
        column_name='x_etat', default='')

    class Meta:
        table_name = 'v_minutes'


class Cadence_Pilulier_Par_Service(BaseModelSuiviProd):

    pk = IntegerField(
        column_name='x_pk', primary_key=True)
    service = CharField(
        unique=True, column_name='x_nomservice')
    heure_debut = CharField(
        column_name='x_heuredebut')
    duree = CharField(
        column_name='x_duree')
    temps_arret = CharField(
        column_name='x_tempsarret')
    nbproduit = IntegerField(
        column_name='x_nbproduit')
    nbproduitheure = IntegerField(
        column_name='x_nbproduitheure')
    nbpilulier = IntegerField(
        column_name='x_nbpilullier')
    nbpilulierheure = IntegerField(
        column_name='x_nbpilullierheure')
    nbplateau = IntegerField(
        column_name='x_nbplateau')
    nbplateauheure = IntegerField(
        column_name='x_nbplateauheure')
    poste = CharField(
        column_name='x_poste')
    chrono = DateTimeField(
        column_name='x_chrono', default='0000-00-00 00:00:00')
    index = IntegerField(
        column_name='x_index')

    class Meta:
        table_name = 'f_cadence_cueillette_pil'


class Cadence_Carnet_Par_Service(BaseModelSuiviProd):

    pk = IntegerField(
        column_name='x_pk', primary_key=True)
    service = CharField(
        unique=True, column_name='x_nomservice')
    heure_debut = CharField(
        column_name='x_heuredebut')
    duree = CharField(
        column_name='x_duree')
    temps_arret = CharField(
        column_name='x_tempsarret')
    nbcarnet = IntegerField(
        column_name='x_nb_carnet')
    nbcarnetheure = IntegerField(
        column_name='x_nb_carnetheure')
    nbproduit = IntegerField(
        column_name='x_nbproduit')
    nbproduitheure = IntegerField(
        column_name='x_nbproduitheure')
    nbpilulier = IntegerField(
        column_name='x_nbpilullier')
    nbpilulierheure = IntegerField(
        column_name='x_nbpilullierheure')
    nbplateau = IntegerField(
        column_name='x_nbplateau')
    nbplateauheure = IntegerField(
        column_name='x_nbplateauheure')
    poste = CharField(
        column_name='x_poste')
    chrono = DateTimeField(
        column_name='x_chrono', default='0000-00-00 00:00:00')
    index = IntegerField(
        column_name='x_index')

    class Meta:
        table_name = 'f_cadence_cueillette_carnet'
