from peewee import (
    AutoField, CharField, IntegerField,
    DateTimeField, TextField
)
from peewee import SQL
from ..base import BaseModel


class LogAstus(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    mag = CharField(
        column_name='x_mag', max_length=3, null=True,
        constraints=[SQL("DEFAULT ''")])
    code_erreur = IntegerField(
        column_name='x_code_erreur')
    utilisateur = CharField(
        column_name='x_utilisateur', max_length=50, null=True,
        constraints=[SQL("DEFAULT ''")])
    adresse = CharField(
        column_name='x_adresse', max_length=19, null=True,
        constraints=[SQL("DEFAULT ''")])
    ref_produit = CharField(
        column_name='x_ref_produit', max_length=35, null=True,
        constraints=[SQL("DEFAULT ''")])
    lot_produit = CharField(
        column_name='x_lot_produit', max_length=20, null=True,
        constraints=[SQL("DEFAULT ''")])
    chrono = DateTimeField(
        column_name='x_chrono', null=True, constraints=[SQL("DEFAULT CURRENT_TIMESTAMP")])
    descriptif = TextField(
        column_name='x_descriptif', null=True)

    class Meta:
        table_name = 'f_log_astus'
        indexes = (
            (('x_mag',), False),
        )


class MessageAstus(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    niveau = IntegerField(
        column_name='x_niveau', constraints=[SQL("DEFAULT 0")])
    message = CharField(
        column_name='x_message', max_length=200,
        constraints=[SQL("DEFAULT ''")])

    class Meta:
        table_name = 'f_message_astus'
        indexes = (
            (('x_niveau',), False),
        )


class LogInfo(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', constraints=[SQL("DEFAULT CURRENT_TIMESTAMP")])
    poste = CharField(
        column_name='x_poste', null=True, max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    section = CharField(
        column_name='x_section', null=True, max_length=16, constraints=[SQL("DEFAULT ''")], default='')
    log = TextField(
        column_name='x_log')

    class Meta:
        table_name = 'f_log_info'
        indexes = (
            (('x_poste',), False),
            (('x_poste', 'x_section'), False),
        )
