from peewee import (
    AutoField,
    CharField,
    IntegerField,
    BooleanField,
    FloatField,
    DateTimeField,
)
from peewee import SQL
from ..base import BaseModel


class Historique(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    reference = CharField(
        column_name='x_ref', null=True, constraints=[SQL("DEFAULT ''")])
    adresse = CharField(
        column_name='x_adr', null=True, constraints=[SQL("DEFAULT ''")])
    quantite_mouvement = FloatField(
        column_name='x_qte_mvt', null=True, constraints=[SQL("DEFAULT 0.000")])
    quantite_totale = FloatField(
        column_name='x_qte_tot', null=True, constraints=[SQL("DEFAULT 0.000")])
    info = CharField(
        column_name='x_info', constraints=[SQL("DEFAULT ''")])
    liste = CharField(
        column_name='x_liste', null=True, constraints=[SQL("DEFAULT ''")])
    service = CharField(
        column_name='x_dest', null=True, constraints=[SQL("DEFAULT ''")])
    type_mouvement = CharField(
        column_name='x_type_mvt', null=True, constraints=[SQL("DEFAULT ''")])
    lot = CharField(
        column_name='x_lot', null=True, constraints=[SQL("DEFAULT ''")])
    adresse_from = CharField(
        column_name='x_adr_from', null=True, constraints=[SQL("DEFAULT ''")])
    utilisateur = CharField(
        column_name='x_user', null=True, constraints=[SQL("DEFAULT ''")])
    commentaire = CharField(
        column_name='x_comment', null=True, constraints=[SQL("DEFAULT ''")])
    # admin = CharField(
    #     column_name='x_admin', null=True, constraints=[SQL("DEFAULT ''")])
    # kit = CharField(
    #     column_name='x_kit', null=True, constraints=[SQL("DEFAULT ''")])
    # emprunt = CharField(
    #     column_name='x_emprunt', null=True, constraints=[SQL("DEFAULT ''")])
    # pmp = FloatField(
    #     column_name='x_pmp', null=True, constraints=[SQL("DEFAULT 0.000")])
    date_peremption = DateTimeField(
        column_name='x_tperemp', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    # date_quarantaine = DateTimeField(
    #     column_name='x_tquarant', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    # prix_unitaire = FloatField(
    #     column_name='x_prix_u', null=True, constraints=[SQL("DEFAULT 0.000")])
    # sequence = CharField(
    #     column_name='x_sequence', null=True, constraints=[SQL("DEFAULT ''")])
    # interface = CharField(
    #     column_name='x_interface', constraints=[SQL("DEFAULT ''")])
    # magasin = CharField(
    #     column_name='x_num_mag', null=True, constraints=[SQL("DEFAULT ''")])
    item = CharField(
        column_name='x_item', null=True, constraints=[SQL("DEFAULT ''")])
    # demandeur = CharField(
    #     column_name='x_demandeur', null=True, constraints=[SQL("DEFAULT ''")])
    # date_demande = CharField(
    #     column_name='x_date_dem', null=True, constraints=[SQL("DEFAULT ''")])
    # heure_demande = CharField(
    #     column_name='x_heure_dem', null=True, constraints=[SQL("DEFAULT ''")])
    # libelle_unite = CharField(
    #     column_name='x_lib_unite', null=True, constraints=[SQL("DEFAULT ''")])
    quantite_demande = FloatField(
        column_name='x_qte_dem', null=True, constraints=[SQL("DEFAULT 0.000")], default=0)
    # numero_demande = FloatField(
    #     column_name='x_num_dem', null=True, constraints=[SQL("DEFAULT 0")])
    # quantite_dispensation = FloatField(
    #     column_name='x_qte_disp', null=True, constraints=[SQL("DEFAULT 0.000")])
    contenant = CharField(
        column_name='x_contenant', null=True, constraints=[SQL("DEFAULT ''")])
    # compte_budget = CharField(
    #     column_name='x_cpt_budg', null=True, constraints=[SQL("DEFAULT ''")])
    # fournisseur = CharField(
    #     column_name='x_four', null=True, constraints=[SQL("DEFAULT ''")])
    fusion = CharField(
        column_name='x_fusion', null=True, constraints=[SQL("DEFAULT ''")])
    # quantite_picking = FloatField(
    #     column_name='x_qte_pick', null=True, constraints=[SQL("DEFAULT 0.000")])
    # quantite_res = FloatField(
    #     column_name='x_qte_res', null=True, constraints=[SQL("DEFAULT 0.000")])
    # refour = CharField(
    #     column_name='x_refour', null=True, constraints=[SQL("DEFAULT ''")])
    # magh2 = BooleanField(
    #     column_name='x_magh2', constraints=[SQL("DEFAULT 0")])
    ipp = CharField(
        column_name='x_num_ipp', constraints=[SQL("DEFAULT ''")])
    sejour = CharField(
        column_name='x_num_sej', constraints=[SQL("DEFAULT ''")])
    # date_service = DateTimeField(
    #     column_name='x_tservice', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    poste = CharField(
        column_name='x_poste', null=True, constraints=[SQL("DEFAULT ''")])
    # type_liste_web = IntegerField(
    #     column_name='x_type_liste_web', constraints=[SQL("DEFAULT 0")])
    # createur = CharField(
    #     column_name='x_createur', constraints=[SQL("DEFAULT ''")])
    # dot = CharField(
    #     column_name='x_dot', constraints=[SQL("DEFAULT ''")])
    quantite_totale_lot = FloatField(
        column_name='x_qte_tot_adr_lot_peremp', constraints=[SQL("DEFAULT 0.000")])
    # date_inventaire_termine = DateTimeField(
    #     column_name='x_t_inv_term', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    pk_liste = IntegerField(
        column_name='x_pk_liste', constraints=[SQL("DEFAULT 0")])
    serial = CharField(
        column_name='x_serial', constraints=[SQL("DEFAULT ''")])
    ucd = CharField(
        column_name='x_ucd', constraints=[SQL("DEFAULT ''")])
    date_prise = DateTimeField(
        column_name='xx_dtprise', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    id_pilulier = CharField(
        column_name='xx_id_pilulier', constraints=[SQL("DEFAULT ''")])
    moment = CharField(
        column_name='xx_moment', constraints=[SQL("DEFAULT ''")])
    heure = CharField(
        column_name='xx_heure', constraints=[SQL("DEFAULT ''")])
    id_prescription = IntegerField(
        column_name='xx_id_presc', constraints=[SQL("DEFAULT 0")])
    readonly = BooleanField(
        column_name='x_readonly', constraints=[SQL("DEFAULT 0")])
    date_debut = DateTimeField(
        column_name='xx_ddeb', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    fraction = IntegerField(
        column_name='x_fraction', constraints=[SQL("DEFAULT 100")])
    quantite_prescrite = FloatField(
        column_name='x_qte_prescrite', constraints=[SQL("DEFAULT 0.000")])
    pk_item = IntegerField(
        column_name='x_pk_item', constraints=[SQL("DEFAULT 0")])
    item_wms = IntegerField(
        column_name='x_item_wms', constraints=[SQL("DEFAULT 0")])
    sous_secteur = CharField(
        column_name='xx_sous_secteur', constraints=[SQL("DEFAULT ''")])
    # id_plateau = CharField(
    #     column_name='xx_id_plateau', constraints=[SQL("DEFAULT ''")])
    # numero_pilulier = IntegerField(
    #     column_name='xx_no_pilulier', constraints=[SQL("DEFAULT 0")])
    # id_peigne = IntegerField(
    #     column_name='xx_id_peigne', constraints=[SQL("DEFAULT 0")])

    class Meta:
        table_name = 'f_histo'


class HistoriqueBlocage(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono',
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    adresse = CharField(
        column_name='x_adr', constraints=[SQL("DEFAULT ''")])
    bloque = BooleanField(
        column_name='x_bloque', constraints=[SQL("DEFAULT 0")])
    reference = CharField(
        column_name='x_ref', constraints=[SQL("DEFAULT ''")])
    ucd = CharField(
        column_name='x_ucd', constraints=[SQL("DEFAULT ''")])
    lot = CharField(
        column_name='x_lot', constraints=[SQL("DEFAULT ''")])
    date_peremption = DateTimeField(
        column_name='x_tperemp',
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    fraction = IntegerField(
        column_name='x_fraction', constraints=[SQL("DEFAULT 0")])
    datalu = CharField(
        column_name='x_datalu', constraints=[SQL("DEFAULT ''")])

    class Meta:
        table_name = 'f_histo_blocage'


class HistoriqueCoupe(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    reference = CharField(
        column_name='x_ref', null=True, constraints=[SQL("DEFAULT ''")])
    designation = CharField(
        column_name='x_desig', null=True, constraints=[SQL("DEFAULT ''")])
    quantite_mouvement = IntegerField(
        column_name='x_qte_mvt', null=True, constraints=[SQL("DEFAULT 0")])
    fraction = IntegerField(
        column_name='x_fraction', constraints=[SQL("DEFAULT 100")])

    class Meta:
        table_name = 'f_histo_coupe'


class HistoriqueIdentification(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono',
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    user = CharField(
        column_name='x_user', constraints=[SQL("DEFAULT ''")])
    demande = CharField(
        column_name='x_demande', constraints=[SQL("DEFAULT ''")])
    liste = CharField(
        column_name='x_liste', constraints=[SQL("DEFAULT ''")])

    class Meta:
        table_name = 'f_histo_identification'


class HistoriqueMultidoses(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    reference = CharField(
        column_name='x_ref', max_length=35, constraints=[SQL("DEFAULT ''")])
    quantite_servi = FloatField(
        column_name='x_qte_serv', constraints=[SQL("DEFAULT 0.000")])
    quantite_demande = FloatField(
        column_name='x_qte_dem', constraints=[SQL("DEFAULT 0.000")])
    service = CharField(
        column_name='x_dest', max_length=30, constraints=[SQL("DEFAULT ''")])
    ipp = CharField(
        column_name='x_ipp', max_length=30,
        constraints=[SQL("DEFAULT ''")])
    sejour = CharField(
        column_name='x_sejour', max_length=35,
        constraints=[SQL("DEFAULT ''")])
    liste = CharField(
        column_name='x_liste', max_length=35,
        constraints=[SQL("DEFAULT ''")])
    coef_conversion = FloatField(
        column_name='x_coef_conv', constraints=[SQL("DEFAULT 0.000")])
    unite_gestion = CharField(
        column_name='x_unit_gest', max_length=20,
        constraints=[SQL("DEFAULT ''")])
    unite_administration = CharField(
        column_name='x_unit_admin', max_length=20,
        constraints=[SQL("DEFAULT ''")])
    delai_peremption = IntegerField(
        column_name='x_delai_peremp', constraints=[SQL("DEFAULT 0")])
    date_prise = DateTimeField(
        column_name='x_dtprise', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])

    class Meta:
        table_name = 'f_histo_multidoses'


class HistoriquePilulier(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    poste = CharField(
        column_name='x_poste', constraints=[SQL("DEFAULT ''")])
    utilisateur = CharField(
        column_name='x_user', constraints=[SQL("DEFAULT ''")])
    pilulier = CharField(
        column_name='x_pilulier', constraints=[SQL("DEFAULT ''")])
    liste = CharField(
        column_name='x_liste', constraints=[SQL("DEFAULT ''")])
    peigne = CharField(
        column_name='x_peigne', constraints=[SQL("DEFAULT ''")])
    erreur_pricer = BooleanField(
        column_name='x_erreur_pricer', constraints=[SQL("DEFAULT 0")])
    conf_pricer = BooleanField(
        column_name='x_conf_pricer', constraints=[SQL("DEFAULT 0")])

    class Meta:
        table_name = 'f_histo_pilulier'


class HistoriquePlateau(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', null=True,
        constraints=[SQL("DEFAULT 'CURRENT_TIMESTAMP'")])
    id_plateau = IntegerField(
        column_name='x_id_plateau', null=True,
        constraints=[SQL("DEFAULT 0")])
    adresse_plateau = CharField(
        column_name='x_adr_plateau', null=True,
        constraints=[SQL("DEFAULT ''")])
    compte_rendu = IntegerField(
        column_name='x_compte_rendu', null=True,
        constraints=[SQL("DEFAULT 0")])

    class Meta:
        table_name = 'f_histo_plateau'


class HistoriquePrise(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    reference = CharField(
        column_name='x_ref', constraints=[SQL("DEFAULT ''")])
    quantite_servi = FloatField(
        column_name='x_qte_serv', constraints=[SQL("DEFAULT 0.000")])
    quantite_demande = FloatField(
        column_name='x_qte_dem', constraints=[SQL("DEFAULT 0.000")])
    service = CharField(
        column_name='x_dest', constraints=[SQL("DEFAULT ''")])
    ipp = CharField(
        column_name='x_ipp', constraints=[SQL("DEFAULT ''")])
    sejour = CharField(
        column_name='x_sejour', constraints=[SQL("DEFAULT ''")])
    liste = CharField(
        column_name='x_liste', constraints=[SQL("DEFAULT ''")])
    coef_conversion = FloatField(
        column_name='x_coef_conv', constraints=[SQL("DEFAULT 0.000")])
    unite_gestion = CharField(
        column_name='x_unit_gest', constraints=[SQL("DEFAULT ''")])
    unite_administration = CharField(
        column_name='x_unit_admin', constraints=[SQL("DEFAULT ''")])
    delai_peremption = IntegerField(
        column_name='x_delai_peremp', constraints=[SQL("DEFAULT 0")])

    class Meta:
        table_name = 'f_histo_prise'


class HistoriqueSachet(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    serial = CharField(
        column_name='x_serial', null=True)
    contenant = CharField(
        column_name='x_contenant', null=True)
    chrono = DateTimeField(
        column_name='x_chrono', null=True, constraints=[SQL("DEFAULT 'CURRENT_TIMESTAMP'")])
    type_mouvement = CharField(
        column_name='x_type_mvt', null=True)
    pk_item = IntegerField(
        column_name='x_pk_item', constraints=[SQL("DEFAULT 0")])
    id_plateau = IntegerField(
        column_name='x_id_plateau', constraints=[SQL("DEFAULT 0")])

    class Meta:
        table_name = 'f_histo_sachet'
