# flake8: noqa
import pytest
from peewee import DoesNotExist
from median.models import Magasin, Espace


class TestModelMagasin:
    def test_unknown_magasin(self):
        """Test d'un magasin inexistant"""
        with pytest.raises(DoesNotExist):
            Magasin.get(mag="MXX")

    def test_create_magasin_bad_eco_type(self):
        """Create a magasin"""
        with pytest.raises(ValueError) as e:
            m = Magasin(mag='M99')
            m.type_mag = 'MEDIAN'
            m.eco_type = '_'
            m.save()
        assert "Bad eco type!" in str(e.value)

    def test_create_magasin_bad(self):
        """Create a magasin"""
        with pytest.raises(ValueError) as e:
            m = Magasin(mag='M99')
            m.eco_type = 'C'
            m.save()
        assert "Type mag is required" in str(e.value)

    def test_create_magasin_tampon(self):
        """Create a Magasin Tampon"""
        m = Magasin(mag='M99', )
        m.type_mag = 'MEDIAN'
        m.libelle = 'Tampon 99'
        m.eco_type = 'T'
        m.save()
        assert m.pk > 0
        m.delete_instance()

    def test_create_magasin_picking(self):
        """Create a Magasin Cueillette"""
        m = Magasin(mag='M99', )
        m.type_mag = 'MEDIAN'
        m.libelle = 'Cueillette 99'
        m.eco_type = 'C'
        m.save()
        assert m.pk > 0
        m.delete_instance()

    def test_create_magasin_retour(self):
        """Create a Magasin Retour"""
        m = Magasin(mag='M99', )
        m.type_mag = 'MEDIAN'
        m.libelle = 'Retour 99'
        m.eco_type = 'R'
        m.save()
        assert m.pk > 0
        m.delete_instance()

    def test_create_magasin_retour(self):
        """Create a Magasin Astus"""
        m = Magasin(mag='M99', )
        m.type_mag = 'MEDIAN'
        m.libelle = 'Astus 99'
        m.eco_type = 'A'
        m.save()
        assert m.pk > 0
        m.delete_instance()

    def test_create_magasin_riedl(self):
        """Create a Magasin Rield"""
        m = Magasin(mag='L01', )
        m.type_mag = 'RIEDL1'
        m.libelle = 'Riedl 1'
        m.eco_type = 'L'
        m.save()
        assert m.pk > 0
        m.delete_instance()


class TestModelEspace:

    def test_unknown_magasin(self):
        with pytest.raises(DoesNotExist):
            Espace.get(mag="MXX")
