
# flake8: noqa
from cmath import rect
import pytest
from peewee import DoesNotExist
from median.database import crypte
from median.auth import check_auth, check_badge, user_auth, user_badge
from median.models import User, Rights
from datetime import datetime


USRTEST = {
    "username": "111111",
    "password": "abcdef",
    "login": "pytest@domain.local",
    "email": "pytest@domain.tld",
    "profil": "ECO-DEX",
}

def test_crypte_password_1():
    """Encryptage mot de passe de 4 caractères (1)"""
    assert crypte('9543') == '>/:-'


def test_crypte_password_2():
    """Encryptage mot de passe de 4 caractères (2)"""
    assert crypte('8822') == '=37-'

def test_crypte_empty_password():
    """Encrypt empty password"""
    assert crypte('') == ''

@pytest.yield_fixture()
def rectest():
    print("Running method level setUp")
    rec_data = {}

    r1 = Rights()
    r1.ressource = 'TEST_R1'
    r1.libelle = 'Test libelle 1'
    r1.save()

    rec_data['r1'] = r1

    yield rec_data

    print("Running method level tearDown")
    r1.delete_instance()

class TestModelUser:

    def test_select_user(self):
        """Utilisateur copilote doit exister"""
        usr_eco = User.get(username='ecopilote')
        assert usr_eco.pk > 0
        assert usr_eco.profil == 'ADMIN'

    def test_unknown_user(self):
        with pytest.raises(DoesNotExist):
            User.get(username='existepas')

    def test_create_user(self):
        """Creation d'un utlisateur"""
        usr = User()
        usr.username = USRTEST['username']
        usr.password = crypte(USRTEST['password'])
        usr.profil = USRTEST['profil']
        usr.date_creation = datetime.now()
        usr.login = USRTEST['login']
        usr.email = USRTEST['email']
        usr.save()

    def test_auth_user_success(self):
        """Authentification utilisateur OK"""
        assert check_auth('111111', 'abcdef')

    def test_auth_user_failed(self):
        """Authentification utilisateur FAIL"""
        assert not check_auth('111111', 'abcde')

    def test_auth_user_auth_success(self):
        """Authentification utilisateur OK"""
        assert user_auth('111111', 'abcdef') > 0

    def test_auth_user_auth_failed(self):
        """Authentification utilisateur FAIL"""
        assert user_auth('111111', 'abcdf') == 0

    def test_email_user_auth_success(self):
        """Authentification user by email OK"""
        assert user_auth(USRTEST['email'], 'abcdef') > 0

    def test_login_user_auth_success(self):
        """Authentification user by email OK"""
        assert user_auth(USRTEST['login'], 'abcdef') > 0

    def test_delete_user(self):
        """Test de creation d'un utilisateur"""
        usr = User.get(username='111111')
        usr.delete_instance()

    def test_create_user_with_badge(self):
        """Creation d'un utlisateur avec badge"""
        usr = User()
        usr.username = '221122'
        usr.password = crypte('abcdef')
        usr.badge = '56123'
        usr.profil = 'ECO-DEX'
        usr.date_creation = datetime.now()
        usr.save()

    def test_auth_user_badge_success(self):
        """Authentification utilisateur avec badge OK"""
        assert check_badge('56123')

    def test_auth_user_badge_failed(self):
        """Authentification utilisateur avec badge FAIL"""
        assert not check_badge('111111')

    def test_auth_user_badge_success_2(self):
        """Authentification utilisateur avec badge OK"""
        assert user_badge('56123') > 0

    def test_auth_user_badge_failed_2(self):
        """Authentification utilisateur avec badge FAIL"""
        assert user_badge('111111') == 0

    def test_delete_user_with_badge(self):
        """Test de creation d'un utilisateur"""
        usr = User.get(username='221122')
        usr.delete_instance()

class TestModelRights:

    def test_unknown_rights(self):
        with pytest.raises(DoesNotExist):
            Rights.get(ressource='unknown')

    def test_select_rights(self, rectest):
        rgt = Rights.get(ressource=rectest['r1'].ressource)
        assert rgt.pk > 0
