from peewee import AutoField, CharField, IntegerField, BooleanField
from peewee import SQL, DoesNotExist

from ..base import BaseModel
from . import Poste

SERVICE_LIST = [
    ('SERVICE', 'Ward'),  # Ward/UF
    ('RIEDL', 'Riedl Exit endpoint'),  # Riedl numero de sortie
]

SERVICE_TYPE = [m[0] for m in SERVICE_LIST]


class Service(BaseModel):
    """USe to declare Ward or Riedl Exit endpoint"""

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    code = CharField(
        column_name='x_dest', unique=True, null=True, constraints=[SQL("DEFAULT ''")])
    libelle = CharField(
        column_name='x_lib_dest', null=True, constraints=[SQL("DEFAULT ''")])
    ordre = IntegerField(
        column_name='x_ordre', null=True, constraints=[SQL("DEFAULT 0")])
    ug = CharField(
        column_name='x_ug', null=True, constraints=[SQL("DEFAULT ''")])
    resp_serv = CharField(
        column_name='x_resp_serv', null=True, constraints=[SQL("DEFAULT ''")])
    cadre_sup = CharField(
        column_name='x_cadre_sup', null=True, constraints=[SQL("DEFAULT ''")])
    cr = CharField(
        column_name='x_cr', null=True, constraints=[SQL("DEFAULT ''")])
    lib_cr = CharField(
        column_name='x_lib_cr', null=True, constraints=[SQL("DEFAULT ''")])
    pole = CharField(
        column_name='x_pole', constraints=[SQL("DEFAULT ''")])
    nb_cde = IntegerField(
        column_name='x_nb_cde', constraints=[SQL("DEFAULT 0")])
    nb_bu = IntegerField(
        column_name='x_nb_bu', constraints=[SQL("DEFAULT 0")])
    nb_item_bu = IntegerField(
        column_name='x_nb_item_bu', constraints=[SQL("DEFAULT 0")])
    type_peigne = IntegerField(
        column_name='x_type_peigne', constraints=[SQL("DEFAULT 0")])
    moment_deb = CharField(
        column_name='x_moment_deb', constraints=[SQL("DEFAULT '0'")], default='matin')
    deb_matin = IntegerField(
        column_name='x_deb_matin', constraints=[SQL("DEFAULT 6")], default=6)
    deb_midi = IntegerField(
        column_name='x_deb_midi', constraints=[SQL("DEFAULT 11")], default=11)
    deb_soir = IntegerField(
        column_name='x_deb_soir', constraints=[SQL("DEFAULT 14")], default=14)
    deb_coucher = IntegerField(
        column_name='x_deb_coucher', constraints=[SQL("DEFAULT 20")], default=20)
    type_dest = CharField(
        column_name='x_type_dest', constraints=[SQL("DEFAULT 'SERVICE'")], default='SERVICE')
    tri = CharField(
        column_name='x_tri', constraints=[SQL("DEFAULT ''")])
    optim_peigne = BooleanField(
        column_name='x_optim_peigne', constraints=[SQL("DEFAULT 0")])
    nb_jour = IntegerField(
        column_name='x_nb_jour', null=True, constraints=[SQL("DEFAULT 0")])
    tri_jour = BooleanField(
        column_name='x_tri_jour', constraints=[SQL("DEFAULT 0")])
    type_carnet = IntegerField(
        column_name='x_type_carnet', null=True, constraints=[SQL("DEFAULT 1")])
    secteur = CharField(
        column_name='x_secteur', null=True, max_length=40, constraints=[SQL("DEFAULT ''")])
    adr1 = CharField(
        column_name='x_adr1', null=True, max_length=40, constraints=[SQL("DEFAULT ''")])
    adr2 = CharField(
        column_name='x_adr2', null=True, max_length=40, constraints=[SQL("DEFAULT ''")])
    adr3 = CharField(
        column_name='x_adr3', null=True, max_length=40, constraints=[SQL("DEFAULT ''")])
    adr4 = CharField(
        column_name='x_adr4', null=True, max_length=40, constraints=[SQL("DEFAULT ''")])

    class Meta:
        table_name = 'f_dest'

    def save(self, force_insert=False, only=None):
        """Enforce control on each information passed"""
        if self.type_dest not in SERVICE_TYPE:
            raise ValueError('Type dest must be: %s' % ','.join(SERVICE_TYPE))
        if self.type_dest == 'RIEDL' and self.secteur is None:
            raise ValueError('Riedl equipment must be defined in secteur, must exists in f_poste')
        if self.type_dest == 'RIEDL' and self.secteur is not None:
            # search if riedl is defined on the f_poste table
            try:
                Poste.get(poste=self.secteur)
            except DoesNotExist:
                raise ValueError('Riedl %s equipment not defined in f_poste' % self.secteur)

        return super().save(force_insert, only)


Endpoint = Service
