from cmath import rect
import pytest
from median.base import BaseView, BaseViewException
# from median.views import Dispensation, Items, Dispensation_Suggestion
from median.models import Poste, Magasin, Endpoint
from median.views import Riedl
import time
from datetime import datetime

@pytest.yield_fixture()
def rectest():
    print("Running method level setUp")
    rec_data = {}

    pos99 = Poste()
    pos99.poste = 'RIEDL_99'
    pos99.pc = 'SERVEUR'
    pos99.save()

    pos00 = Poste()
    pos00.poste = 'RIEDL_00'
    pos00.pc = 'SERVEUR'
    pos00.save()

    whs99 = Magasin()
    whs99.mag = 'L99'
    whs99.type_mag = pos99.poste
    whs99.eco_type = 'L'
    whs99.id_robot = 'R01'
    whs99.id_zone = 'TMP'
    whs99.save()

    whs00 = Magasin()
    whs00.mag = 'L00'
    whs00.type_mag = pos00.poste
    whs00.eco_type = 'L'
    whs00.id_robot = 'R00'
    whs00.id_zone = 'TMP'
    whs00.save()

    enptlb99 = Endpoint()
    enptlb99.code = 'L99.LB01'
    enptlb99.libelle = 'Loading Bay 1 / Sortie urgence'
    enptlb99.secteur = pos99.poste
    enptlb99.type_dest = 'RIEDL'
    enptlb99.save()

    enptex1_99 = Endpoint()
    enptex1_99.code = 'L99.EX01'
    enptex1_99.libelle = 'Exit 1 / Sortie 1'
    enptex1_99.secteur = pos99.poste
    enptex1_99.type_dest = 'RIEDL'
    enptex1_99.save()

    enptex2_99 = Endpoint()
    enptex2_99.code = 'L99.EX02'
    enptex2_99.libelle = 'Exit 2 / Sortie 2'
    enptex2_99.secteur = pos99.poste
    enptex2_99.type_dest = 'RIEDL'
    enptex2_99.save()

    rec_data['riedl99'] = pos99
    rec_data['riedl00'] = pos00
    rec_data['whs99'] = whs99
    rec_data['whs00'] = whs00
    rec_data['enptlb99'] = enptlb99
    rec_data['enptex1_99'] = enptex1_99
    rec_data['enptex2_99'] = enptex2_99

    yield rec_data

    print("Running method level tearDown")
    enptlb99.delete_instance()
    enptex1_99.delete_instance()
    enptex2_99.delete_instance()
    whs99.delete_instance()
    whs00.delete_instance()
    pos99.delete_instance()
    pos00.delete_instance()


class TestViewRiedl:

    def test_init_riedlview_without_poste(self):
        """
        Test d'initialisation de la classe
        """
        with pytest.raises(BaseViewException) as e:
            rdl = Riedl()
        assert 'poste must be required' in str(e.value)

    def test_init_riedlview_unknown(self):
        """Instanciate Riedl with unknonw poste"""
        with pytest.raises(BaseViewException) as e:
            rdl = Riedl('UNKNOWN')
        assert 'does not exists' in str(e.value)

    def test_init_riedlview(self, rectest):
        """Test instance with known Riedl"""
        rdl = Riedl(rectest['riedl99'].poste)

    def test_riedlview_warehouse(self, rectest):
        """Retrieve warehouse associat to a Riedl"""
        rdl = Riedl(rectest['riedl99'].poste)
        assert len(rdl.warehouses) == 1
        assert rdl.warehouses[0].mag == rectest['whs99'].mag

    def test_riedlview_endpoints(self, rectest):
        """Retrieve warehouse associat to a Riedl"""
        rdl = Riedl(rectest['riedl99'].poste)
        assert len(rdl.endpoints) == 3

    def test_riedlview_add_endpoint(self, rectest):
        """Add new endpoint """
        rdl = Riedl(rectest['riedl00'].poste)
        assert rdl.poste.poste == rectest['riedl00'].poste
        assert len(rdl.warehouses) == 1
        assert rdl.warehouses[0].mag == rectest['whs00'].mag
        epc = rdl.add_endpoint('L00.LB01', 'Loading bay 1', 1, 1)
        assert len(rdl.endpoints) == 1
        epc1 = rdl.add_endpoint('L00.EX01', 'Exit 1', 1, 1)
        assert len(rdl.endpoints) == 2
        epc2 = rdl.add_endpoint('L00.EX02', 'Exit 2', 1, 1)
        assert len(rdl.endpoints) == 3
        epc1.delete_instance()
        epc2.delete_instance()
        epc.delete_instance()
