# flake8: noqa
import pytest
from peewee import DoesNotExist
from median.models import Service, Poste
import time
from datetime import datetime


class TestModelService:

    def test_unknown_service(self):
        """Test d'un service inexistant"""
        with pytest.raises(DoesNotExist):
            Service.get(code='INCONNU')

    def test_create_service(self):
        """Test de creation d'uns service"""
        ser = Service()
        ser.code = "ECOSERV"
        ser.libelle = "Service de test"
        ser.save()
        assert ser.pk > 0
        ser.delete_instance()

    def test_create_service(self):
        """Test de creation d'un service"""
        ser = Service()
        ser.code = "ECOSERV"
        ser.libelle = "Service de test"
        ser.type_dest = 'SERVICE'
        ser.save()
        assert ser.pk > 0
        ser.delete_instance()

    def test_create_service_bad_type(self):
        """Test de creation d'un service avec un mauvais type"""
        with pytest.raises(ValueError):
            ser = Service()
            ser.code = "ECOBAD"
            ser.libelle = "Bad Service"
            ser.type_dest = 'TEST'
            ser.save()

    def test_create_riedl_exit_point_lb_failed(self):
        """Test de creation d'uns service"""
        with pytest.raises(ValueError) as e:
            ser = Service()
            ser.code = "L99.LB01"
            ser.libelle = "Loading Bay / Urgence"
            ser.type_dest = "RIEDL"
            ser.save()
        assert 'equipment must be defined in secteur' in str(e.value)

    def test_create_riedl_exit_point_lb_without_poste(self):
        """Test de creation d'uns service"""
        with pytest.raises(ValueError) as e:
            ser = Service()
            ser.code = "L99.LB01"
            ser.libelle = "Loading Bay / Urgence"
            ser.type_dest = "RIEDL"
            ser.secteur = 'RIEDL_99'
            ser.save()
        assert 'equipment not defined in f_poste' in str(e.value)

    def test_create_riedl_exit_point_lb(self):
        """Test de creation d'un service"""
        pos = Poste()
        pos.poste = 'RIEDL_99'
        pos.pc = 'SERVEUR'
        pos.save()
        assert pos.pk > 0

        ser = Service()
        ser.code = "L99.LB01"
        ser.libelle = "Loading Bay / Urgence"
        ser.type_dest = "RIEDL"
        ser.secteur = 'RIEDL_99'
        ser.save()
        assert ser.pk > 0

        ser.delete_instance()
        pos.delete_instance()
