from ..base import BaseView, BaseViewException
from peewee import DoesNotExist
# from median.database import mysql_db
from median.models import Poste, Magasin, Endpoint
import logging

logger = logging.getLogger('median')


class RiedlViewException(Exception):
    def __init__(self, message):
        self.message = message


class Riedl(BaseView):
    """Represent a Riedl Instance"""
    poste = None
    warehouses = []
    endpoints = []

    def __init__(self, poste=None):
        """Implement an instance of the Riedl"""
        self.mandatory(poste, "poste must be required!")
        try:
            self.poste = Poste.get(poste=poste)
        except DoesNotExist:
            raise BaseViewException("Poste %s does not exists" % poste)

        # Retrieve all warehouse relate to this equipment (1 is necessary)
        self.warehouses = Magasin().select(Magasin.mag, Magasin.id_robot, Magasin.id_zone).where(
            Magasin.eco_type == 'L', Magasin.type_mag == self.poste.poste)

        self.endpoints = self.get_endpoints()

    def add_endpoint(self, name, label='Unknown', priority=3, ep_number=1):
        """Add new endpoints for the this Riedl
           Priority: 3 default, 0 more, 5 less

        """
        ap = Endpoint()
        ap.code = name
        ap.libelle = label
        ap.secteur = self.poste.poste
        ap.type_dest = 'RIEDL'
        ap.ordre = priority
        ap.type_peigne = ep_number
        ap.save()

        self.endpoints = self.get_endpoints()
        return ap

    def get_endpoints(self):
        """Retrieve liste of all endpoints"""
        return Endpoint().select(Endpoint).where(
            Endpoint.type_dest == 'RIEDL', Endpoint.secteur == self.poste.poste)
