# flake8: noqa
import pytest
from median.base import BaseView, BaseViewNotImplemented, BaseViewDuplicate


class TestClassBaseView:

    def test_init_baseview(self):
        """
        Test d'initialisation de la classe
        """
        bv = BaseView()
        assert bv is not None

    def test_protect_data_1(self):
        """
        Vérification des protection des données
        l'apostrophe
        """
        bv = BaseView()
        pt = bv._protect("L'idole des jeunes")
        assert pt == "L\\'idole des jeunes"

    def test_protect_data_2(self):
        """
        Vérification des protection des données
        l'anti slash
        """
        bv = BaseView()
        pt = bv._protect(r"c:\Windows\System32\test")
        assert pt == r"c:\\Windows\\System32\\test"

    def test_protect_data_3(self):
        """
        Vérification des protection des données
        le code hexa 0 (0x00) voir \0 en C
        """
        bv = BaseView()
        pt = bv._protect(r"Fin de ligne\0")
        assert pt == r"Fin de ligne\\0"

    def test_protect_data_4(self):
        """
        Vérification des protection des données
        Code ASCII 26 pour END-OF-FILE
        """
        bv = BaseView()
        pt = bv._protect(r"Fin de ligne\Z")
        assert pt == r"Fin de ligne\\Z"

    def test_protect_data_5(self):
        """
        Vérification des protection des données
        Caractère tabulation
        """
        bv = BaseView()
        pt = bv._protect(r"Fin de ligne\t")
        assert pt == r"Fin de ligne\\t"

    def test_protect_data_6(self):
        """
        Vérification des protection des données
        Caractère backspace
        """
        bv = BaseView()
        pt = bv._protect(r"Backspace\b")
        assert pt == r"Backspace\\b"

    def test_protect_data_6(self):
        """
        Vérification des protection des données
        Caractère backspace
        """
        bv = BaseView()
        pt = bv._protect(r'Double"Quote')
        assert pt == r'Double\"Quote'

    def test_render_query(self):
        """
        Launch query
        """
        bv = BaseView()
        query = "SELECT x_ref FROM f_ref"
        res = bv.render_query(query)
        assert len(res) > 0

    def test_baseview_creer(self):
        bv = BaseView()
        with pytest.raises(BaseViewNotImplemented) as e:
            bv.creer()
        assert "Fonction creer() non implementée" in str(e.value)

    def test_baseview_modifier(self):
        bv = BaseView()
        with pytest.raises(BaseViewNotImplemented) as e:
            bv.modifier()
        assert "Fonction modifier() non implementée" in str(e.value)

    def test_baseview_suprimer(self):
        bv = BaseView()
        with pytest.raises(BaseViewNotImplemented) as e:
            bv.supprimer()
        assert "Fonction supprimer() non implementée" in str(e.value)

    def test_baseview_lire(self):
        bv = BaseView()
        with pytest.raises(BaseViewNotImplemented) as e:
            bv.lire()
        assert "Fonction lire() non implementée" in str(e.value)

    def test_baseview_duplicate(self):

        with pytest.raises(BaseViewDuplicate) as e:
            raise BaseViewDuplicate('test view duplicate exception')
        assert "test view duplicate exception" in str(e.value)
