from peewee import AutoField, CharField, IntegerField, BooleanField, DateTimeField
from peewee import SQL

from ..base import BaseModel


class Poste(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    poste = CharField(
        column_name='x_poste', null=True, max_length=20, constraints=[SQL("DEFAULT ''")])
    pc = CharField(
        column_name='x_pc', null=True, max_length=20, constraints=[SQL("DEFAULT ''")])
    tdepuis = DateTimeField(
        column_name='x_tdepuis', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    ecr = CharField(
        column_name='x_ecr', null=True, max_length=20, constraints=[SQL("DEFAULT ''")])
    tostop = BooleanField(
        column_name='x_tostop', null=True, constraints=[SQL("DEFAULT 0")], default=0)
    tversion = DateTimeField(
        column_name='x_tversion', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    proc_pid = IntegerField(
        column_name='x_proc_pid', constraints=[SQL("DEFAULT 0")], default=0)

    class Meta:
        table_name = 'f_poste'
        indexes = (
            (('x_poste', 'x_pc'), True),
        )
