from peewee import (
    AutoField,
    CharField,
    IntegerField,
    BooleanField,
    FloatField,
    DateTimeField,
)
from peewee import SQL

from ..base import BaseModel


class Stock(BaseModel):

    pk = AutoField(column_name="x_pk", primary_key=True)
    adresse = CharField(column_name="x_adr", null=True, constraints=[SQL("DEFAULT ''")])
    reference = CharField(
        column_name="x_ref", null=True, constraints=[SQL("DEFAULT ''")]
    )
    quantite = FloatField(
        column_name="x_qte", null=True, constraints=[SQL("DEFAULT 0.000")]
    )
    id_fifo = IntegerField(
        column_name="x_id_fifo", null=True, constraints=[SQL("DEFAULT 0")]
    )
    lot = CharField(column_name="x_lot", null=True, constraints=[SQL("DEFAULT ''")])
    admin = CharField(column_name="x_admin", null=True, constraints=[SQL("DEFAULT ''")])
    date_peremption = DateTimeField(
        column_name="x_tperemp",
        null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")],
    )
    date_entree = DateTimeField(
        column_name="x_tentree",
        null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")],
    )
    date_sortie = DateTimeField(
        column_name="x_tsortie",
        null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")],
    )
    date_invent = DateTimeField(
        column_name="x_tinvent",
        null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")],
    )
    info = CharField(column_name="x_info", null=True, constraints=[SQL("DEFAULT ''")])
    # condition = FloatField(
    #     column_name="x_condi", null=True, constraints=[SQL("DEFAULT 0.000")]
    # )
    bloque = IntegerField(
        column_name="x_bloque", null=True, constraints=[SQL("DEFAULT 0")]
    )
    contenant = CharField(
        column_name="x_contenant", null=True, constraints=[SQL("DEFAULT ''")]
    )
    magasin = CharField(column_name="x_mag", null=True, constraints=[SQL("DEFAULT ''")])
    reinteg = BooleanField(
        column_name="x_reinteg", null=True, constraints=[SQL("DEFAULT 0")]
    )
    # manquant = BooleanField(column_name="x_manquant", constraints=[SQL("DEFAULT 0")])
    ucd = CharField(column_name="x_ucd", constraints=[SQL("DEFAULT ''")])
    # etat = CharField(column_name="x_etat", constraints=[SQL("DEFAULT ''")])
    serial = CharField(column_name="x_serial", constraints=[SQL("DEFAULT ''")])
    zone_admin = CharField(column_name="x_zone_admin", constraints=[SQL("DEFAULT ''")])
    fraction = IntegerField(column_name="x_fraction", constraints=[SQL("DEFAULT 100")])
    capa = IntegerField(column_name="x_capa", null=True, constraints=[SQL("DEFAULT 0")])

    class Meta:
        table_name = "f_stock"


class CodeBlocage(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    valeur = IntegerField(
        column_name='x_valeur', constraints=[SQL("DEFAULT 0")], default=0)
    libelle = CharField(
        column_name='x_libelle', max_length=250, constraints=[SQL("DEFAULT ''")], default='')

    class Meta:
        table_name = 'f_defaut'
        indexes = (
            (('x_valeur',), True)
        )
