# flake8: noqa
import pytest
from peewee import DoesNotExist
from median.models import Service
import time
from datetime import datetime


class TestModelService:

    def test_unknown_service(self):
        """Test d'un service inexistant"""
        with pytest.raises(DoesNotExist):
            Service.get(code='INCONNU')

    def test_create_service(self):
        """Test de creation d'uns service"""
        ser = Service()
        ser.code = "ECOSERV"
        ser.libelle = "Service de test"
        ser.save()
        assert ser.pk > 0
        ser.delete_instance()