# flake8: noqa
import pytest
from peewee import DoesNotExist
from median.models import Sejour
import time
from datetime import datetime


class TestModelSejour:

    def test_unknown_sejour(self):
        """Test d'un sejour inexistant"""
        with pytest.raises(DoesNotExist):
            Sejour.get(sejour='INCONNU')

    def test_unknown_sejour_ipp1(self):
        """Recherche un sejour par l'IPP"""
        with pytest.raises(DoesNotExist):
            Sejour.get(ipp='INCONNU')

    def test_unknown_sejour_ipp2(self):
        """Rechercher un sejour par l'IPP"""
        with pytest.raises(DoesNotExist):
            Sejour.get(ipp='INCONNU',sejour='INCONNU')

    def test_create_sejour(self):
        """Creation d'un sejour"""
        sej = Sejour()
        sej.ipp = "ECO1234"
        sej.sejour = "SEJ1234"
        sej.date_entree = datetime.now()
        sej.save()
        assert sej.pk > 0
        assert sej.date_entree.strftime('%Y-%m-%d') == time.strftime('%Y-%m-%d')
        sej.delete_instance()


