from peewee import (
    CharField,
    FloatField,
    DateTimeField,
)
from peewee import SQL
from ..base import BaseModel


class Emplacements(BaseModel):

    adr = CharField(
        column_name='x_adr', null=True, constraints=[SQL("DEFAULT ''")])
    ref = CharField(
        column_name='x_ref', null=True, constraints=[SQL("DEFAULT ''")])
    bloque = CharField(
        column_name='x_bloque', null=True, constraints=[SQL("DEFAULT ''")])
    libelle = CharField(
        column_name='x_libelle', null=True, constraints=[SQL("DEFAULT ''")])
    etat = CharField(
        column_name='x_etat', null=True, constraints=[SQL("DEFAULT ''")])
    x_format = CharField(
        column_name='x_format', null=True, constraints=[SQL("DEFAULT ''")])
    qte = FloatField(
        column_name='x_qte', null=True, constraints=[SQL("DEFAULT 0")])
    fraction = FloatField(
        column_name='x_fraction', null=True, constraints=[SQL("DEFAULT ''")])
    ucd = CharField(
        column_name='x_ucd', null=True, constraints=[SQL("DEFAULT ''")])
    sortie = DateTimeField(
        column_name='x_tsortie', null=True, constraints=[SQL("DEFAULT ''")])
    entree = DateTimeField(
        column_name='x_tentree', constraints=[SQL("DEFAULT ''")])
    lot = CharField(
        column_name='x_lot', constraints=[SQL("DEFAULT ''")])
    peremp = DateTimeField(
        column_name='x_tperemp', constraints=[SQL("DEFAULT 0")])
    contenant = DateTimeField(
        column_name='x_contenant', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    designation = CharField(
        column_name='x_desig', null=True, constraints=[SQL("DEFAULT ''")])
    magasin = CharField(
        column_name='x_mag', null=True, constraints=[SQL("DEFAULT ''")])
    taquin = CharField(
        column_name='x_taquin', null=True, constraints=[SQL("DEFAULT ''")])
    demi_taquin = CharField(
        column_name='x_demi_taquin', null=True, constraints=[SQL("DEFAULT ''")])

    class Meta:
        table_name = 'v_emplacements'
