
from peewee import Model
from .database import mysql_db, mysql_db_suivi_prod


class BaseModel(Model):
    """A base model that will use our MySQL database"""
    class Meta:
        database = mysql_db
        table_settings = ['ENGINE=MyISAM', 'DEFAULT CHARSET=utf8']


class BaseModelSuiviProd(Model):
    """A base model that will use our MySQL database"""
    class Meta:
        database = mysql_db_suivi_prod
        table_settings = ['ENGINE=MyISAM', 'DEFAULT CHARSET=utf8']


class BaseViewException(Exception):
    def __init__(self, message):
        self.message = message


class BaseViewNotImplemented(Exception):
    def __init__(self, message):
        self.message = message


class BaseViewDuplicate(Exception):
    def __init__(self, message):
        self.message = message


class BaseView:
    """
    Business object to add standard function
    """

    id = 0

    def __init__(self):
        """Initialise BaseView class"""
        pass

    #
    # Fonction publique
    #
    def creer(self):
        raise BaseViewNotImplemented('Fonction creer() non implementée')

    def modifier(self):
        raise BaseViewNotImplemented('Fonction modifier() non implementée')

    def supprimer(self):
        raise BaseViewNotImplemented('Fonction supprimer() non implementée')

    def lire(self):
        raise BaseViewNotImplemented('Fonction lire() non implementée')

    def mandatory(self, data, message=""):
        """Return an axception if data is None"""
        if data is None:
            raise BaseViewException(message)

    def non_zero(self, data, message=""):
        if data is None or data == 0:
            raise BaseViewException(message)

    def render_query(self, query):
        """Execute a query and return the result a list of dict"""

        cr = mysql_db.execute_sql(query)
        column_names = [x[0] for x in cr.description]
        return [dict(zip(column_names, row)) for row in cr.fetchall()]

    #
    # Fonction privée
    #

    @staticmethod
    def _protect(data):
        """
        Protège les données avant de les envoyés en tant que requête SQL
        """
        data = data.replace("\\", "\\\\")
        data = data.replace("'", "\\'")
        data = data.replace('"', '\\"')
        return data
