#
# Generate peewee model from MySQL Database
#
# flake8: noqa

import os
import sys

# import _mysql
import MySQLdb

DB_HOST = os.environ.get("MEDIAN_DB_HOST", "192.168.60.137")
DB_PORT = int(os.environ.get("MEDIAN_DB_PORT", 3306))
DB_USER = os.environ.get("MEDIAN_DB_USER", "root")
DB_PASS = os.environ.get("MEDIAN_DB_PASS", "root")
DB_NAME = os.environ.get("MEDIAN_DB_NAME", "test")


DB_TABLE = "v_emplacements"
DB_MODEL = "emplacements"

TYPE_FIELD = []

mydb = MySQLdb.connect(
    host=DB_HOST, port=DB_PORT, user=DB_USER, passwd=DB_PASS, db=DB_NAME
)
cr = mydb.cursor(MySQLdb.cursors.DictCursor)


print("from peewee import SQL\n")
print("from ..base import BaseModel\n\n")

Query = """
SELECT `TABLE_NAME` AS table_name, `COLUMN_NAME` AS column_name, `ORDINAL_POSITION` AS column_order, `COLUMN_DEFAULT` AS column_defaut, 
       `IS_NULLABLE` AS can_be_null, `DATA_TYPE` AS column_datatype, `CHARACTER_MAXIMUM_LENGTH` AS column_length, `NUMERIC_PRECISION` AS  num_prec, 
       `NUMERIC_SCALE` AS num_scale, `DATETIME_PRECISION` AS date_prec, `COLUMN_KEY` AS column_key, `EXTRA` AS extra, `COLUMN_COMMENT` AS column_comment,
       `COLUMN_TYPE` AS column_type
FROM information_schema.`COLUMNS`
WHERE table_schema = '%s'
AND `TABLE_NAME` = '%s'
ORDER BY `ORDINAL_POSITION`;
""" % (
    DB_NAME,
    DB_TABLE,
)

try:
    cr.execute(Query)

    print("class %s(BaseModel):\n" % DB_MODEL)
    for row in cr.fetchall():
        col_attrs = []
        col_type = ""
        new_col_name = row["column_name"].replace("xx_", "").replace("x_", "").lower()
        col_attrs.append("""column_name='%s'""" % row["column_name"])
        if row["column_key"] == "UNI":
            col_attrs.append("unique=True")
        elif row["column_key"] == "PRI":
            col_attrs.append("primary_key=True")
        if row["can_be_null"] == "YES":
            col_attrs.append("null=True")

        if row["column_key"] == "PRI":
            if row["extra"] == "auto_increment":
                col_type = "AutoField"
            else:
                col_type = "IntegerField"
        elif row["column_datatype"] == "varchar":
            col_type = "CharField"
            if row["column_defaut"] is not None:
                col_attrs.append(
                    """constraints=[SQL("DEFAULT '%s'")]""" % row["column_defaut"]
                )
        elif row["column_datatype"] == "text":
            col_type = "TextField"
            if row["column_defaut"] is not None:
                col_attrs.append(
                    """constraints=[SQL("DEFAULT '%s'")]""" % row["column_defaut"]
                )
        elif row["column_datatype"] in ("datetime", "timestamp"):
            col_type = "DateTimeField"
            if row["column_defaut"] is not None:
                col_attrs.append(
                    """constraints=[SQL("DEFAULT '%s'")]""" % row["column_defaut"]
                )
        elif row["column_datatype"] == "date":
            col_type = "DateField"
            if row["column_defaut"] is not None:
                col_attrs.append(
                    """constraints=[SQL("DEFAULT '%s'")]""" % row["column_defaut"]
                )
        elif row["column_datatype"] in ("int", "tinyint", "smallint"):
            col_type = "IntegerField"
            if (
                row["column_datatype"] == "tinyint"
                and row["column_type"] == "tinyint(1)"
            ):
                col_type = "BooleanField"
            if row["column_defaut"] is not None:
                col_attrs.append(
                    """constraints=[SQL("DEFAULT %s")]""" % row["column_defaut"]
                )
        elif row["column_datatype"] in ("float",):
            col_type = "FloatField"
            if row["column_defaut"] is not None:
                col_attrs.append(
                    """constraints=[SQL("DEFAULT %s")]""" % row["column_defaut"]
                )
        else:
            print(row)
        print(
            "    %s = %s(\n        %s)" % (new_col_name, col_type, ", ".join(col_attrs))
        )

finally:
    print("\n    class Meta:\n        table_name = '%s'\n" % DB_TABLE)
    if mydb:
        mydb.close()
